% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regulonSimilarities.R
\name{permuteGraph}
\alias{permuteGraph}
\title{Calculate similarity score from permuted graphs to estimate background similarity}
\usage{
permuteGraph(graph, focal_tf, n = 100, p = 1)
}
\arguments{
\item{graph}{an igraph object from \code{buildGraph} or \code{buildDiffGraph}}

\item{focal_tf}{character string indicating the name of the transcription factors to
calculate similarity score}

\item{n}{an integer indicating the number of permutations}

\item{p}{a scalar indicating the probability of rewiring the graphs}
}
\value{
A matrix with Jaccard similarity between the focal transcription factor and all pairs of transcription factors
for n permuted graphs
}
\description{
Calculate similarity score from permuted graphs to estimate background similarity
}
\examples{
regulon <- data.frame(tf = sample(letters[1:4], 100, replace = TRUE), idxATAC= 1:100,
target = sample(letters[5:14], 100, replace = TRUE))
regulon$weights <- runif(100)
GRN_graph <- buildGraph(regulon)
permuted_graph <- permuteGraph(GRN_graph, focal_tf = "a")
}
