% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalizeCounts.R
\name{normalizeCounts}
\alias{normalizeCounts}
\title{Normalize counts}
\usage{
normalizeCounts(object, control, span = 1, ...)
}
\arguments{
\item{object}{an epigraHMMDataSet}

\item{control}{list of control arguments from controlEM()}

\item{span}{the span parameter of \code{\link[limma]{loessFit}} (default is 1)}

\item{...}{arguments to be passed to \code{\link[limma]{loessFit}} for loess calculation}
}
\value{
An epigraHMMDataSet with an 'offsets' assay filled in.
}
\description{
This function performs a non-linear normalization of counts with respect to a reference sample (geometric mean)
}
\details{
This function `limma::loessFit`, which simply a wrapper for the `stats::lowess` smoother.
}
\examples{

# Creating dummy object
countData <- list('counts' = matrix(rpois(1e5,10),ncol = 2),
'controls' = matrix(rpois(1e5,5),ncol = 2))
colData <- data.frame(condition = c('A','A'), replicate = c(1,2))
object <- epigraHMMDataSetFromMatrix(countData,colData)

# Normalizing counts
object <- normalizeCounts(object = object,control = controlEM(), span = 1)

}
\references{
\url{https://github.com/plbaldoni/epigraHMM}
}
\author{
Pedro L. Baldoni, \email{pedrobaldoni@gmail.com}
}
