% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initializer.R
\name{initializer}
\alias{initializer}
\title{Initializer of epigraHMM}
\usage{
initializer(object, control)
}
\arguments{
\item{object}{an epigraHMMDataSet}

\item{control}{list of control arguments from controlEM()}
}
\value{
An epigraHMMDataSet with a 'peaks' assay filled in.
}
\description{
This function call enriched windows individually for each sample in an epigraHMMDataSet.
These are then used for initializing purposes in epigraHMM. By default, the Viterbi algorithm
is used to determine enriched windows. Input controls and normalizing offsets are not utilized
in this initialization step.
}
\details{
To be added
}
\examples{
# Creating dummy object
countData <- rbind(matrix(rnbinom(1e3,mu = 2,size = 10),ncol = 1),
                   matrix(rnbinom(2e3,mu = 7.5,size = 5),ncol = 1),
                   matrix(rnbinom(1e3,mu = 2,size = 10),ncol = 1))

colData <- data.frame(condition = 'A', replicate = 1)
object <- epigraHMMDataSetFromMatrix(countData,colData)

# Initializing
object <- initializer(object,controlEM())

# Visualizing initialization peaks
#plot(assay(object),type = 'l')
#lines(7.5*assay(object,'peaks'),col = 'red')

}
\references{
\url{https://github.com/plbaldoni/epigraHMM}
}
\author{
Pedro L. Baldoni, \email{pedrobaldoni@gmail.com}
}
