% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/heatplot.R
\name{heatplot}
\alias{heatplot}
\alias{heatplot,enrichResult-method}
\alias{heatplot,gseaResult-method}
\alias{heatplot.enrichResult}
\title{heatplot}
\usage{
heatplot(x, showCategory = 30, ...)

\S4method{heatplot}{enrichResult}(x, showCategory = 30, ...)

\S4method{heatplot}{gseaResult}(x, showCategory = 30, ...)

heatplot.enrichResult(
  x,
  showCategory = 30,
  symbol = "rect",
  foldChange = NULL,
  pvalue = NULL,
  label_format = 30
)
}
\arguments{
\item{x}{enrichment result.}

\item{showCategory}{number of enriched terms to display}

\item{...}{Additional parameters}

\item{symbol}{symbol of the nodes, one of "rect"(the default) and "dot"
by default wraps names longer that 30 characters}

\item{foldChange}{fold Change.}

\item{pvalue}{pvalue of genes}

\item{label_format}{a numeric value sets wrap length, alternatively a
custom function to format axis labels.}
}
\value{
ggplot object
}
\description{
heatmap like plot for functional classification
}
\examples{
library(DOSE)
data(geneList)
de <- names(geneList)[1:100]
x <- enrichDO(de)
heatplot(x)
}
\author{
Guangchuang Yu
}
