% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodsEmapInternal.R
\encoding{UTF-8}
\name{createCompareResultDataFrame}
\alias{createCompareResultDataFrame}
\title{Create a data frame containing the compiled enrichment results from
multiple queries}
\usage{
createCompareResultDataFrame(queryList, gostResultsList)
}
\arguments{
\item{queryList}{a \code{list} containing the query names.}

\item{gostResultsList}{a \code{list} of \code{data.frame} containing 
the enrichment results to be plot with different group identification.}
}
\value{
a \code{data.frame} object
}
\description{
The function creates a data frame object using the
list of queries and list of enrichment results given be the user.
}
\examples{

## Load the result of an enrichment analysis done with gprofiler2
data(parentalNapaVsDMSOEnrichment)

## Only retain the results section
gostResults <- as.data.frame(parentalNapaVsDMSOEnrichment$result)

## Limit the results subsection of REACTOME and KEGG
## Kegg is replicated to show shared results between queries
gostResultsREAC <- gostResults[which(gostResults$source == "REAC"),]
gostResultsREAC <- gostResultsREAC[1:13, ]
gostResultsKEGG <- gostResults[which(gostResults$source == "KEGG"),]
gostResultsKEGG2 <- gostResultsKEGG[1:6,]

## List of query names with duplicated names
queryList <- list("parental_vs_DMSO", "rosa_vs_DMSO", "parental_vs_DMSO", 
    "rosa_vs_DMSO", "parental_vs_Control", "rosa_vs_DMSO")
    
## Extract meta data information
queryList <- list("parental - REACTOME", "parental - KEGG - v1", 
    "parental - KEGG - v2")

## Change the query names for the duplicated names
enrichViewNet:::createCompareResultDataFrame(queryList=queryList,
    gostResultsList=list(gostResultsREAC, gostResultsKEGG, 
            gostResultsKEGG2))
    
}
\author{
Astrid Deschênes
}
\keyword{internal}
