% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracing.R
\name{mkdCodeChunkComplete,easyreporting-method}
\alias{mkdCodeChunkComplete,easyreporting-method}
\title{mkdCodeChunkComplete}
\usage{
\S4method{mkdCodeChunkComplete}{easyreporting}(
  object,
  code,
  optionList = getOptionsList(object),
  sourceFilesList = NULL
)
}
\arguments{
\item{object}{an easyreporting class object}

\item{code}{a string or an expression (or a list of expressions) generated 
with \link[base]{quote} containing a function call or the entire code chunk to trace.}

\item{optionList}{a list of options.}

\item{sourceFilesList}{a list of files to source.}
}
\value{
none
}
\description{
it creates a complete code chunk.
}
\examples{
\dontrun{
rd <- easyreporting(filenamePath="./project_report",
                        title="example_report", author=c("It's me"))
mkdCodeChunkComplete(rd, code=c(quote(a <- 1), quote(b <- 2), quote(c<-  a+b), 
quote(print(c))))
mkdCodeChunkComplete(rd, code="a <- 1\n b <- 2\n c <- a+b\n print(c)")
}
}
