% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/easyRNASeq-package.R
\name{easyRNASeq package}
\alias{easyRNASeq package}
\alias{easyRNASeq-package}
\alias{assay}
\alias{type}
\alias{BamFileList}
\alias{BamFileList-class}
\alias{IRanges}
\alias{GRanges-class}
\alias{GRanges}
\alias{SRFilterResult}
\alias{SummarizedExperiment}
\alias{RangedSummarizedExperiment-class}
\alias{chromosomeFilter}
\alias{compose}
\alias{nFilter}
\title{Count summarization and normalization pipeline for Next Generation Sequencing data.}
\description{
Offers functionalities to summarize read counts per feature of interest, e.g. exons, transcripts, genes, etc.
Offers functionalities to normalize the summarized counts using a 3rd party package: \code{\link[edgeR:DGEList]{edgeR}}.
}
\section{Methods}{

The main function \code{\link[easyRNASeq:easyRNASeq-easyRNASeq]{easyRNASeq}} will summarize the counts per
feature of interest, for as many samples as provided and will return a
count matrix (N*M) where N are the features and M the samples.
This data can be corrected to \pkg{RPKM} in which case
a matrix of corrected value is returned instead, with the same dimensions.
Using RPKM is only advisable for visualization purposes and should never be used for Differential Expression
with edgeR or DESeq2.
Alternatively a \code{\linkS4class{RangedSummarizedExperiment}} can be returned and this
is expected to be the default in the upcoming version of easyRNASeq (as of 1.5.x).
If the necessary sample
information are provided, the data can be normalized using \code{\link[edgeR:DGEList]{edgeR}} and the corresponding object returned.
For more insider details, and step by step functions, see:
\tabular{ll}{
	\code{\link[easyRNASeq:ShortRead-methods]{ShortRead methods}} for pre-processing the data.
	\code{\link[easyRNASeq:easyRNASeq-annotation-methods]{easyRNASeq annotation methods}} for getting the annotation.
	\code{\link[easyRNASeq:easyRNASeq-coverage-methods]{easyRNASeq coverage methods}} for computing the coverage from a Short Read Alignment file.
	\code{\link[easyRNASeq:easyRNASeq-summarization-methods]{easyRNASeq summarization methods}} for summarizing the data.
	\code{\link[easyRNASeq:easyRNASeq-correction-methods]{easyRNASeq correction methods}} for correcting the data (i.e. generating RPKM).
	\code{\link[easyRNASeq:edgeR-methods]{edgeR methods}} for post-processing the data.
	}
}

\examples{
 # the data
 tdir <- tutorialData()

  # get the example annotation file - we retrieve a gtf file from GitHub
  annot <- fetchData("Drosophila_melanogaster.BDGP5.77.with-chr.gtf.gz")

  # create the AnnotParam
  annotParam <- AnnotParam(
    datasource=annot,
    type="gtf")

  # create the synthetic transcripts
  annotParam <- createSyntheticTranscripts(annotParam,verbose=FALSE)

 # create the RnaSeqParam
 rnaSeqParam <- RnaSeqParam(annotParam=annotParam,countBy="gene")

  # get the bamfiles (from the Bioc cache in this example)
 filenames <- dir(tdir,pattern="[A,T].*\\\\.bam$",full.names=TRUE)
 indexnames <- sapply(paste0(sub(".*_","",basename(filenames)),".bai"),fetchData)
 bamFiles <- getBamFileList(filenames,indexnames)

 # get a RangedSummarizedExperiment containing the counts table
  sexp <- simpleRNASeq(
      bamFiles=bamFiles,
      param=rnaSeqParam,
      verbose=TRUE
  )

  # get the counts
  assays(sexp)$genes


}
\seealso{
The class RNAseq specification:
	\code{\linkS4class{RNAseq}}

  The default output class specification:
  \code{\linkS4class{RangedSummarizedExperiment}}

	The imported packages:
	\code{\link[biomaRt:useEnsembl]{biomaRt}}
  \code{\link[BiocParallel:BiocParallel-package]{BiocParallel}}
	\code{\link[edgeR:DGEList]{edgeR}}
	\code{\link[genomeIntervals:Genome_intervals_stranded-class]{genomeIntervals}}
	\code{\link[Biostrings:XString-class]{Biostrings}}
	\code{\link[BSgenome:BSgenome-class]{BSgenome}}
	\code{\link[GenomicRanges:GRanges-class]{GenomicRanges}}
	\code{\link[IRanges:IRanges-constructor]{IRanges}}
	\code{\link[Rsamtools:scanBam]{Rsamtools}}
	\code{\link[ShortRead:readAligned]{ShortRead}}

	The suggested packages:
	\code{\link[parallel:makeCluster]{parallel}}
	\code{\link[GenomicFeatures:TxDb-class]{GenomicFeatures}}

  The following classes and functions that are made available from
  other packages:
  \itemize{
    \item{Classes}{
      \code{\link[Rsamtools:BamFile-class]{BamFileList-class}}
      \code{\linkS4class{RangedSummarizedExperiment}}
    }
    \item{Functions/Methods}{
      \code{\link[SummarizedExperiment:RangedSummarizedExperiment-class]{
        The RangedSummarizedExperiment assay accessor}
      }
      The BamFileList constructor \code{\link[Rsamtools:BamFile-class]{BamFileList-class}}
      The IRanges constructor \code{\link[IRanges]{IRanges-constructor}}
      For the SRFilterResult,
      chromosomeFilter, compose and nFilter methods\code{\link[ShortRead]{srFilter}}
    }
  }
}
\author{
Nicolas Delhomme, Bastian Schiffthaler, Ismael Padioleau
}
\keyword{"_PACKAGE"}
\keyword{internal}
\keyword{package}
