% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmtlr_test.R
\name{rmtlr_test}
\alias{rmtlr_test}
\title{Regularized Multi-Task Linear Regression (RMTLR)
model predictions}
\usage{
rmtlr_test(x_test, coef_matrix)
}
\arguments{
\item{x_test}{numeric matrix containing features values
(rows = samples; columns = features).}

\item{coef_matrix}{numeric matrix containing the parameters
values derived from model training (rows = features;
columns = tasks).}
}
\value{
Numeric matrix of predicted values (rows = samples;
columns = tasks).
}
\description{
Computes the predictions as a matrix multiplication using
both the features input data and the features estimated
weights.
}
\examples{
\donttest{
# using a SummarizedExperiment object
library(SummarizedExperiment)
# Using example exemplary dataset (Mariathasan et al., Nature, 2018)
# from easierData. Original processed data is available from
# IMvigor210CoreBiologies package.
library("easierData")

dataset_mariathasan <- easierData::get_Mariathasan2018_PDL1_treatment()
RNA_tpm <- assays(dataset_mariathasan)[["tpm"]]

# Select a subset of patients to reduce vignette building time.
pat_subset <- c(
  "SAM76a431ba6ce1", "SAMd3bd67996035", "SAMd3601288319e",
  "SAMba1a34b5a060", "SAM18a4dabbc557"
)
RNA_tpm <- RNA_tpm[, colnames(RNA_tpm) \%in\% pat_subset]

# Computation of TF activity (Garcia-Alonso et al., Genome Res, 2019)
tf_activities <- compute_TF_activity(
  RNA_tpm = RNA_tpm
)

# Parameters values should be defined as a matrix
# with features as rows and tasks as columns
estimated_parameters <- matrix(rnorm(n = (ncol(tf_activities) + 1) * 10),
  nrow = ncol(tf_activities) + 1, ncol = 10
)
rownames(estimated_parameters) <- c("(Intercept)", colnames(tf_activities))
colnames(estimated_parameters) <- c(
  "CYT", "Ock_IS", "Roh_IS", "chemokines",
  "Davoli_IS", "IFNy", "Ayers_expIS", "Tcell_inflamed", "RIR", "TLS"
)

# Compute predictions using parameters values
pred_test <- rmtlr_test(
  x_test = tf_activities,
  coef_matrix = estimated_parameters
)
}
}
