% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotForest.R
\name{plotForest}
\alias{plotForest}
\alias{plotForest,dreamletResult-method}
\alias{plotForest,dreamlet_mash_result-method}
\title{Forest plot}
\usage{
plotForest(x, gene, coef, ...)

\S4method{plotForest}{dreamletResult}(x, gene, coef, assays = names(x), ylim = NULL)

\S4method{plotForest}{dreamlet_mash_result}(x, gene, coef, assays = colnames(x$logFC.original), ylim = NULL)
}
\arguments{
\item{x}{result from \code{dreamlet}}

\item{gene}{gene to show results for}

\item{coef}{coefficient to test with \code{topTable}}

\item{...}{other arguments}

\item{assays}{array of assays to plot}

\item{ylim}{limits for the y axis}
}
\value{
Plot showing effect sizes
}
\description{
Forest plot
}
\examples{
library(muscat)
library(SingleCellExperiment)

data(example_sce)

# create pseudobulk for each sample and cell cluster
pb <- aggregateToPseudoBulk(example_sce,
  assay = "counts",
  cluster_id = "cluster_id",
  sample_id = "sample_id",
  verbose = FALSE
)

# voom-style normalization
res.proc <- processAssays(pb, ~group_id)

# Differential expression analysis within each assay,
# evaluated on the voom normalized data
res.dl <- dreamlet(res.proc, ~group_id)

# show coefficients estimated for each cell type
coefNames(res.dl)

# Show estimated log fold change with in each cell type
plotForest(res.dl, gene = "ISG20", coef = "group_idstim")

}
