% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dreamlet.R
\name{getTreat,dreamletResult-method}
\alias{getTreat,dreamletResult-method}
\alias{getTreat,dreamletResult,dreamletResult-method}
\title{Test if coefficient is different from a specified value}
\usage{
\S4method{getTreat}{dreamletResult}(fit, lfc = log2(1.2), coef = NULL, number = 10, sort.by = "p")
}
\arguments{
\item{fit}{dreamletResult object}

\item{lfc}{a minimum log2-fold-change below which changes not considered scientifically meaningful}

\item{coef}{which coefficient to test}

\item{number}{number of genes to return}

\item{sort.by}{column to sort by}
}
\value{
\code{DataFrame} storing hypothesis test for each gene and cell type
}
\description{
Test if coefficient is different from a specified value
}
\examples{
library(muscat)
library(SingleCellExperiment)

data(example_sce)

# create pseudobulk for each sample and cell cluster
pb <- aggregateToPseudoBulk(example_sce,
  assay = "counts",
  cluster_id = "cluster_id",
  sample_id = "sample_id",
  verbose = FALSE
)

# voom-style normalization
res.proc <- processAssays(pb, ~group_id)

# Differential expression analysis within each assay,
# evaluated on the voom normalized data
res.dl <- dreamlet(res.proc, ~group_id)

# show coefficients estimated for each cell type
coefNames(res.dl)

# extract results using limma-style syntax
# combines all cell types together
# adj.P.Val gives study-wide FDR
getTreat(res.dl, coef = "group_idstim", number = 3)

}
\seealso{
\code{limma::topTreat()}, \code{variancePartition::getTreat()}
}
