% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_transcripts.R
\name{extract_transcripts}
\alias{extract_transcripts}
\title{Create a new dataframe of protein features from dataframe with multiple
transcripts separated so that each transcript is drawn separtely with
only the appropriate features.}
\usage{
extract_transcripts(data)
}
\arguments{
\item{data}{Dataframe of one or more rows with the following column
names: 'type', 'description', 'begin', 'end', 'length', 'accession',
'entryName', 'taxid', 'order'. Must contain a minimum of one "CHAIN" as
data$type.}
}
\value{
A dataframe with extra rows if there were multiple transcripts
present. Extra transcripts will have an order at the end of the object
Each new row should have 9 variables including type, description, begin,
end, length, accession, entryName, taxid and order for plotting.
}
\description{
This function works on the object returned by the get_features() function.
It creates a data.frame of features and includes the accession number AND
an order number. It uses the extract_feat_acc function
}
\examples{
data(five_rel_data)
new_data <- extract_transcripts(five_rel_data)
# because there are two entries with two transcripts
max(new_data$order) # should now be 7...

}
