% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geoms.R
\name{draw_recept_dom}
\alias{draw_recept_dom}
\title{Add receptor domains to ggplot2 object.}
\usage{
draw_recept_dom(p, data = data, alpha = 1.0, label_domains = FALSE, label_size = 4,
         show.legend = TRUE)
}
\arguments{
\item{p}{ggplot2 object ideally created with \code{\link{draw_canvas}}.}

\item{data}{Dataframe of one or more rows with the following column
names: 'type', 'description', 'begin', 'end', 'length', 'accession',
'entryName', 'taxid', 'order'. Uses TOPO_DOM and TRANSMEM type to plot
these parts of receptors}

\item{alpha}{Transparency of the rectangles representing the receptor domains.}

\item{label_domains}{Option to label receptor domains or not.}

\item{label_size}{Size of the text used for labels.}

\item{show.legend}{Option to include legend in this layer}
}
\value{
A ggplot2 object either in the plot window or as an object with an
additional geom_rect layer.
}
\description{
\code{draw_recept_dom} adds receptor domains to the ggplot2 object created by
\code{\link{draw_chains}}.
It uses the data object.
The ggplot2 function \code{geom_rect} is used to draw each of the domain
chains proportional to their number of amino acids (length).
}
\examples{
# combines with draw_chains to plot chains and domains.
# we like to draw receptors vertically so flip using ggplot2 functions
# scale_x_reverse and coord_flip
data("tnfs_data")
p <- draw_canvas(tnfs_data)
p <- draw_chains(p, tnfs_data, label_size = 1.25)
draw_recept_dom(p, tnfs_data) + ggplot2::scale_x_reverse() +
ggplot2::coord_flip()

}
