% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotExpr.R
\name{plotExpr}
\alias{plotExpr}
\title{plotExpr Function to generate a boxplot (expression) for a
SummarizedExperiment object based on the replicate data.}
\usage{
plotExpr(se, groupings= NULL, mode_mean=TRUE,
treatment=levels(colData(se)$Treatment),
LOG2=TRUE, clusterby_grouping=TRUE, ...)
}
\arguments{
\item{se}{A SummarizedExp object containing FPKM values and at least
one annotation column.}

\item{groupings}{Specifies which column in the dataframe of the
annotation slot that will be used to group loci in the boxplot.
Can provide either a character value matching the column name,
or a single numerical value used as an index of dataframe columns.}

\item{mode_mean}{Logical. If TRUE then FPKM values are averaged by
mean across replicates within treatment. If FALSE, values are
averaged by median.}

\item{treatment}{A character vector indicating which treatments
(i.e. levels in the replicates slot vector) will be plotted.
Order matters, and controls the ordering of treatments represented
in the boxplot.}

\item{LOG2}{Logical. If TRUE then average FPKM values are Log2
transformed.}

\item{clusterby_grouping}{Logical. If TRUE then boxplots are arranged
by locus annotation grouping. If FALSE they are arranged by treatment
levels, as indicated in the treatment argument.}

\item{...}{Additional named arguments and graphical parameters passed
to the boxplot function.}
}
\value{
Returns an invisible data frame containing values
and labels used to generate the figure.
}
\description{
This function generates a boxplot of FPKM expression
values from the supplied object. FPKM values are averaged
across replicates and partitioned among groups of loci as specified
in a selected column from the annotation slot of the provided
object.
}
\details{
This function generates boxplots to visualize the distribution
of FPKM expression values provided in an object, arranged by
selected treatments and locus annotations. FPKM values are averaged
(mean or median) within selected treatments, to provide a single
expression value per locus per treatment. Loci are partitioned
into groupings based on a specified column in the dataframe of
annotations slot of the object. Thus a box is drawn for
each grouping of loci for each treatment indicated. Desired treatments
and their ordering are specified by the treatment argument. Groupings
are arranged by sort order of the annotation column indicated, and can
thus be controlled by providing a factor with a pre-specified level order.
By default (clusterby_grouping = TRUE), boxes are arranged by annotation
group first, and then by treatment, but setting this option to FALSE
arranges boxes by treatment and then annotation group. This function uses
the base graphics boxplot function to generate the plot, so can accept
all relevant graphical arguments for customizing the figure;
see boxplot for details.
}
\examples{
data(hmel.se)
plotExpr(se, groupings = "annotation.ZA", treatment = 'Male' )
}
\references{
The 'doseR' package, 2018 (in press).
}
\author{
AJ Vaestermark, JR Walters.
}
