% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sn.R
\name{dst}
\alias{dst}
\alias{pst}
\alias{qst}
\alias{rst}
\title{Skew-t Distribution}
\usage{
dst(x, location = 0, scale = 1, shape = 0, df = Inf, dp = NULL, log = FALSE)

rst(n = 1, location = 0, scale = 1, shape = 0, df = Inf, dp = NULL)

pst(x, location = 0, scale = 1, shape = 0, df = Inf, dp = NULL, ...)

qst(
  p,
  location = 0,
  scale = 1,
  shape = 0,
  df = Inf,
  tol = 1e-06,
  dp = NULL,
  ...
)
}
\arguments{
\item{x}{vector of quantiles. Missing values (\code{NA}s) are allowed.}

\item{location}{vector of location parameters.}

\item{scale}{vector of (positive) scale parameters.}

\item{shape}{vector of shape parameters. With \code{pst} and \code{qst}, it
must be of length 1.}

\item{df}{degrees of freedom (scalar); default is \code{df=Inf} which
corresponds to the skew-normal distribution.}

\item{dp}{a vector of length 4, whose elements represent location, scale
(positive), shape and df, respectively.  If \code{dp} is specified, the
individual parameters cannot be set.}

\item{log}{logical; if TRUE, densities are given as log-densities.}

\item{n}{sample size.}

\item{...}{additional parameters passed to \code{integrate}.}

\item{p}{vector of probabililities}

\item{tol}{a scalar value which regulates the accuracy of the result of
\code{qsn}.}
}
\value{
Density (\code{dst}), probability (\code{pst}), quantiles
(\code{qst}) and random sample (\code{rst}) from the skew-\eqn{t}
distribution with given \code{location}, \code{scale}, \code{shape} and
\code{df} parameters.
}
\description{
Density function, distribution function and random number generation for the
skew-\eqn{t} (ST) distribution.  Functions copied from \code{sn} CRAN
library v0.4.18 for argument name compatibility with \code{st.mle} function
from the same version.
}
\section{Details}{
 Typical usages are \preformatted{% dst(x, location=0,
scale=1, shape=0, df=Inf, log=FALSE) dst(x, dp=, log=FALSE) pst(x,
location=0, scale=1, shape=0, df=Inf, ...) pst(x, dp=, log=FALSE) qst(p,
location=0, scale=1, shape=0, df=Inf, tol=1e-8, ...) qst(x, dp=, log=FALSE)
rst(n=1, location=0, scale=1, shape=0, df=Inf) rst(x, dp=, log=FALSE) }
}

\examples{

pdf <- dst(seq(-4,4,by=0.1), shape=3, df=5)
rnd <- rst(100, 5, 2, -5, 8)
q <- qst(c(0.25,0.5,0.75), shape=3, df=5)
stopifnot(identical(all.equal(pst(q, shape=3, df=5), c(0.25,0.5,0.75)), TRUE))

}
\references{
Azzalini, A. and Capitanio, A. (2003). Distributions generated
by perturbation of symmetry with emphasis on a multivariate skew-\emph{t}
distribution. \emph{J.Roy. Statist. Soc. B} \bold{65}, 367--389.
}
\seealso{
\code{\link{st.mle}}
}
\keyword{distribution}
