% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{findUnivariateGammaWithSupport}
\alias{findUnivariateGammaWithSupport}
\title{Search for optimal gamma and associated support}
\usage{
findUnivariateGammaWithSupport(seMat, gamma = c(1:9/100, 1:9/10),
  beta = 0.95, alpha = 0.01, parallel = TRUE, verbose = TRUE)
}
\arguments{
\item{seMat}{SummariziedExperiment with an assay in [0, 1], with each column corresponding to a sample and each 
row corresponding to a feature; usually in quantile form.}

\item{gamma}{Range of gamma values to search through. 
By default gamma = \{0.01, 0.02, ... 0.09, 0.1, 0.2, ..., 0.9\}.}

\item{beta}{Parameter for eliminating outliers (0 < beta <= 1). By default beta=0.95.}

\item{alpha}{Expected proportion of divergent features per sample to be estimated
over the samples in Mat. By default alpha = 0.01; i.e. search for the smallest gamma that provides
1\% or less number of divergent features per sample.}

\item{parallel}{Logical indicating whether to compute features parallelly with mclapply on
Unix based systems (defaults to TRUE, switched to FALSE if parallel package is not available).}

\item{verbose}{Logical indicating whether to print status related messages during computation (defaults
to TRUE).}
}
\value{
A list with elements "Ranges": data frame with the baseline interval 
for each feature, "Support": binary matrix of the same dimensions as Mat indicating whether each sample was a support 
for a feature or not (1=support, 0=not in the support), "gamma": gamma value, and "alpha": the expected number of divergent 
features per sample estimated over the samples, "optimal": logical indicaing whether the 
selected gamma value provided the necessary alpha requirement, and "alpha_space": a data frame with alpha values 
for each gamma searched.
}
\description{
Function for searching through a range of gamma values for finding the smallest gamma that 
provides expected proportion of divergent features per sample less than or equal to alpha.
}
\examples{
baseMat = breastTCGA_Mat[, breastTCGA_Group == "NORMAL"]
seMat.base = SummarizedExperiment(assays=list(data=baseMat))
assays(seMat.base)$quantile = computeQuantileMatrix(seMat.base)
baseline = findUnivariateGammaWithSupport(seMat=seMat.base)

}
\keyword{gamma}
