% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fpPercHeatmap.R
\name{fpPercHeatmap}
\alias{fpPercHeatmap}
\title{fpPercHeatmap}
\usage{
fpPercHeatmap(
  footprint_percentages,
  breaks = rep(list(c(0, 50, 100)), 5),
  plotcols = c("#236467", "#AA9B39", "#822B56", "#822B26", "#822B99")
)
}
\arguments{
\item{footprint_percentages}{A tibble where each column
corresponds to a sample-footprint percentage and each row to a ROI,
with the rows clustered by similarity.}

\item{breaks}{A list of vectors indicating numeric breaks used
in (\code{ColorRamp2}) to define the heatmap color gradient,
with one element per pattern (usually 5, or 3 if the nucleosome
patterns have been combined).}

\item{plotcols}{A character vector of 5 colors to be used for
the heatmaps of the 5 footprint
patterns ("tf", "open", "upNuc", "Nuc", "downNuc"), or 3
colors if the nucleosome patterns have been combined.}
}
\value{
Heatmaps of the percentages of all fragments in a
ROI-sample combination in each footprint pattern.
}
\description{
Draws heatmaps of the percentages of all fragments in
a ROI-sample combination in each footprint pattern.
}
\details{
Draws heatmaps of the percentages of all fragments in a
ROI-sample combination in each
footprint pattern supplied (for example: "tf", "open", "upNuc",
"Nuc", "downNuc"). The rows of the heatmaps are split by ROI group.
}
\examples{
NomeData <- createExampleData()
NomeData <- footprintCalc(NomeData)
NomeData <- footprintQuant(NomeData)
footprint_percentages <- footprintPerc(NomeData)
fpPercHeatmap(footprint_percentages)

}
