% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/plot.R
\docType{methods}
\name{plot,diggit-method}
\alias{plot}
\alias{plot,diggit-method}
\title{Diggit plot}
\usage{
\S4method{plot}{diggit}(x, mr = NULL, cluster = NULL, sub = NULL, ...)
}
\arguments{
\item{x}{Diggit class object}

\item{mr}{Optional vector of character strings indicating the MR names}

\item{cluster}{Optional vector of cluster names}

\item{sub}{Optional sub-title for the plot}

\item{...}{Additional parameters to pass to the plot function}
}
\value{
Nothing, plots are generated in the default output device
}
\description{
This function generate plots for the diggit conditional analysis
}
\examples{
data(gbm.expression, package="diggitdata")
data(gbm.cnv, package="diggitdata")
data(gbm.aracne, package="diggitdata")
dobj <- diggitClass(expset=gbmExprs, cnv=gbmCNV, regulon=gbmTFregulon)
dobj <- fCNV(dobj)
dobj <- aqtl(dobj, mr=c("CEBPD", "STAT3"), fcnv.adjust="fdr", verbose=FALSE)
dobj <- conditional(dobj, pheno="subtype", group1="MES", group2="PN", mr="STAT3", verbose=FALSE)
plot(dobj, cluster="3")
}

