% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/aqtl.R
\docType{methods}
\name{aqtl}
\alias{aqtl}
\alias{aqtl,diggit-method}
\title{Inference of aQTL}
\usage{
aqtl(x, ...)

\S4method{aqtl}{diggit}(x, mr = 0.01, mr.adjust = c("none", "fdr",
  "bonferroni"), fcnv = 0.01, fcnv.adjust = c("none", "fdr", "bonferroni"),
  method = c("spearman", "mi", "pearson", "kendall"), mindy = FALSE,
  cores = 1, verbose = TRUE)
}
\arguments{
\item{x}{Object of class diggit}

\item{...}{Additional parameters to pass to the function}

\item{mr}{Either a numerical value between 0 and 1 indicating the p-value threshold for the Master Regulator (MR) selection, or a vector of character strings listing the MRs}

\item{mr.adjust}{Character string indicating the multiple hypothesis test correction for the MRs}

\item{fcnv}{Either a numerical value between 0 and 1 indicating the p-value threshold for the F-CNV, or a vector of character strings listing the F-CNVs}

\item{fcnv.adjust}{Character string indicating the multiple hypothesis test correction for the F-CNVs}

\item{method}{Character string indicating the method for computing the association between F-CNV and regulator activity (aQTL analysis)}

\item{mindy}{Logical, whether only post-translational modulators of each evaluated TF should be considered as putative genetic driver}

\item{cores}{Integer indicating the number of cores to use (1 for Windows-based systems)}

\item{verbose}{Logical, whether progress should be reported}
}
\value{
Updated diggit object with viper and aqtl slots
}
\description{
This function infers aQTLs from F-CNVs and VIPER activity
}
\examples{
data(gbm.expression, package="diggitdata")
data(gbm.cnv, package="diggitdata")
data(gbm.aracne, package="diggitdata")
dobj <- diggitClass(expset=gbmExprs, cnv=gbmCNV, regulon=gbmTFregulon)
dobj <- fCNV(dobj)
dobj <- aqtl(dobj, mr=c("CEBPD", "STAT3"), fcnv.adjust="fdr")
dobj
diggitAqtl(dobj)[, 1:4]
}

