% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRegionCoverage.R
\name{plotRegionCoverage}
\alias{plotRegionCoverage}
\title{Makes plots for every region while summarizing the annotation}
\usage{
plotRegionCoverage(
  regions,
  regionCoverage,
  groupInfo,
  nearestAnnotation,
  annotatedRegions,
  txdb = NULL,
  whichRegions = seq_len(min(100, length(regions))),
  colors = NULL,
  scalefac = 32,
  ask = interactive(),
  ylab = "Coverage",
  verbose = TRUE
)
}
\arguments{
\item{regions}{The \verb{$regions} output from
\link[derfinder:calculatePvalues]{calculatePvalues}.}

\item{regionCoverage}{The output from \link[derfinder:getRegionCoverage]{getRegionCoverage}
used on \code{regions}.}

\item{groupInfo}{A factor specifying the group membership of each sample. It
will be used to color the samples by group.}

\item{nearestAnnotation}{The output from \link[bumphunter:matchGenes]{matchGenes}
used on \code{regions}.}

\item{annotatedRegions}{The output from \link[derfinder:annotateRegions]{annotateRegions}
used on \code{regions}.}

\item{txdb}{A \link[GenomicFeatures:TxDb-class]{TxDb} object. If specified, transcript
annotation will be extracted from this object and used to plot the
transcripts.}

\item{whichRegions}{An integer vector with the index of the regions to plot.}

\item{colors}{If \code{NULL} then \link[RColorBrewer:ColorBrewer]{brewer.pal} with the
\code{'Dark2'} color scheme is used.}

\item{scalefac}{The parameter used in \link[derfinder:preprocessCoverage]{preprocessCoverage}.}

\item{ask}{If \code{TRUE} then the user is prompted before each plot is made.}

\item{ylab}{The name of the of the Y axis.}

\item{verbose}{If \code{TRUE} basic status updates will be printed along the
way.}
}
\value{
A plot for every region showing the coverage of each sample at each
base of the region as well as the summarized annotation information.
}
\description{
This function takes the regions found in \link[derfinder:calculatePvalues]{calculatePvalues}
and assigns them genomic states contructed with
\link[derfinder:makeGenomicState]{makeGenomicState}. The main workhorse functions are
\link[IRanges:findOverlaps-methods]{countOverlaps} and \link[IRanges:findOverlaps-methods]{findOverlaps}. For an
alternative plot check \link{plotCluster} which is much slower and we
recommend it's use only after quickly checking the results with this
function.
}
\examples{
## Load data
library("derfinder")

## Annotate regions, first two regions only
regions <- genomeRegions$regions[1:2]
annotatedRegions <- annotateRegions(
    regions = regions,
    genomicState = genomicState$fullGenome, minoverlap = 1
)

## Find nearest annotation with bumphunter::matchGenes()
library("bumphunter")
library("TxDb.Hsapiens.UCSC.hg19.knownGene")
genes <- annotateTranscripts(txdb = TxDb.Hsapiens.UCSC.hg19.knownGene)
nearestAnnotation <- matchGenes(x = regions, subject = genes)

## Obtain fullCov object
fullCov <- list("21" = genomeDataRaw$coverage)

## Assign chr lengths using hg19 information
library("GenomeInfoDb")
seqlengths(regions) <- seqlengths(getChromInfoFromUCSC("hg19",
    as.Seqinfo = TRUE
))[
    mapSeqlevels(names(seqlengths(regions)), "UCSC")
]

## Get the region coverage
regionCov <- getRegionCoverage(fullCov = fullCov, regions = regions)
#
## Make plots for the regions
plotRegionCoverage(
    regions = regions, regionCoverage = regionCov,
    groupInfo = genomeInfo$pop, nearestAnnotation = nearestAnnotation,
    annotatedRegions = annotatedRegions, whichRegions = 1:2
)

## Re-make plots with transcript information
plotRegionCoverage(
    regions = regions, regionCoverage = regionCov,
    groupInfo = genomeInfo$pop, nearestAnnotation = nearestAnnotation,
    annotatedRegions = annotatedRegions, whichRegions = 1:2,
    txdb = TxDb.Hsapiens.UCSC.hg19.knownGene
)
\dontrun{
## If you prefer, you can save the plots to a pdf file
pdf("ders.pdf", h = 6, w = 9)
plotRegionCoverage(
    regions = regions, regionCoverage = regionCov,
    groupInfo = genomeInfo$pop, nearestAnnotation = nearestAnnotation,
    annotatedRegions = annotatedRegions, whichRegions = 1:2,
    txdb = TxDb.Hsapiens.UCSC.hg19.knownGene, ask = FALSE
)
dev.off()
}

}
\seealso{
\link[derfinder:calculatePvalues]{calculatePvalues},
\link[derfinder:getRegionCoverage]{getRegionCoverage},
\link[bumphunter:matchGenes]{matchGenes}, \link[derfinder:annotateRegions]{annotateRegions},
\link{plotCluster}
}
\author{
Andrew Jaffe, Leonardo Collado-Torres
}
