% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcGSA.R
\name{dcGSA}
\alias{dcGSA}
\title{Perform gene set analysis for longitudinal gene expression profiles.}
\usage{
dcGSA(data = NULL, geneset = NULL, nperm = 10, c = 0, KeepPerm=FALSE,
  parallel = FALSE, BPparam = MulticoreParam(workers = 4))
}
\arguments{
\item{data}{A list with ID (a character vector for subject ID),
pheno (a data frame with each column being one clinical outcome),
gene (a data frame with each column being one gene).}

\item{geneset}{A list of gene sets of interests (the output of
\code{\link{readGMT}} function).}

\item{nperm}{An integer number of permutations performed to get P values.}

\item{c}{An integer cutoff value for the overlapping number of genes
between the data and the gene set.}

\item{KeepPerm}{A logical value indicating if the permutation statistics are
         kept. If there are a large number of gene sets and the number of 
         permutation is large, the matrix of the permutation statistics could
         be large and memory demanding.}

\item{parallel}{A logical value indicating if parallel computing is wanted.}

\item{BPparam}{Parameters to configure parallel evaluation environments
if parallel is TRUE. The default value is to use 4 cores in a single
machine. See \code{\link{BiocParallelParam}} object in Bioconductor
package \code{BiocParallel} for more details.}
}
\value{
Returns a data frame with following columns, if KeepPerm=FALSE; otherwise, 
returns a list with two objects: "res" object being the following data frame 
and "stat" being  the permutation statistics.
\item{Geneset}{Names for the gene sets.}
\item{TotalSize}{The original size of each gene set.}
\item{OverlapSize}{The overlapping number of genes between
                   the data and the gene set.}
\item{Stats}{Longitudinal distance covariance between the clinical outcomes
             and the gene set.}
\item{NormScore}{Only available when permutation is performed.
      Normalized longitudinal distance covariance using the mean and
      standard deviation of permutated values.}
\item{P.perm}{Only available when permutation is performed. Permutation P 
              values.}
\item{P.approx}{P values obtained using normal distribution to approximate the 
                null distribution.}
\item{FDR.approx}{FDR based on the P.approx.}
}
\description{
Perform gene set analysis for longitudinal gene expression profiles.
}
\examples{
data(dcGSAtest)
fpath <- system.file("extdata", "sample.gmt.txt", package="dcGSA")
GS <- readGMT(file=fpath)
system.time(res <- dcGSA(data=dcGSAtest,geneset=GS,nperm=100))
head(res)
}
\references{
Distance-correlation based Gene Set Analysis in Longitudinal
            Studies. Jiehuan Sun, Jose Herazo-Maya, Xiu Huang,
            Naftali Kaminski, and Hongyu Zhao.
}

