% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_taxa.R
\name{zero_otu}
\alias{zero_otu}
\alias{zero_otu,Recipe-method}
\alias{zero_otu,phyloseq-method}
\title{Extract outs with all 0 values in at least on level of the variable}
\usage{
zero_otu(obj, var = NULL, pct_cutoff = 0)

\S4method{zero_otu}{Recipe}(obj, var = NULL, pct_cutoff = 0)

\S4method{zero_otu}{phyloseq}(obj, var = NULL, pct_cutoff = 0)
}
\arguments{
\item{obj}{A \code{Recipe} or \code{phyloseq} object.}

\item{var}{Variable of interest. Must be present in the metadata.}

\item{pct_cutoff}{Minimum of pct counts samples with counts for each taxa.}
}
\value{
character vector
}
\description{
Extract outs with all 0 values in at least on level of the variable
}
\examples{
data(metaHIV_phy)

## Init Recipe
rec <- recipe(metaHIV_phy, "RiskGroup2", "Species")

## Extract outs with all 0 values
zero_otu(rec)
}
