% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{use_rarefy}
\alias{use_rarefy}
\title{Perform Rarefaction on Phyloseq Object}
\usage{
use_rarefy(phy, rarefy)
}
\arguments{
\item{phy}{A phyloseq object.}

\item{rarefy}{A logical value indicating whether to perform rarefaction. If
'no_seed', rarefaction is performed without a set seed. If FALSE, no
rarefaction is performed.}
}
\value{
A phyloseq object after rarefaction if \code{rarefy} is TRUE or "no_seed",
otherwise the original phyloseq object is returned.
}
\description{
This function performs rarefaction on a phyloseq object if the \code{rarefy}
parameter is set to TRUE. Rarefaction is a process that randomly subsamples
the data to a specified depth. This is done to account for differences in
sequencing depth between samples. However, this process is not without
controversy. Rarefaction can lead to loss of information and can also lead to
false positives in differential abundance testing. For more information, see
https://microbiomejournal.biomedcentral.com/articles/10.1186/s40168-019-0650-2
}
\examples{
data(metaHIV_phy)

## With seed
# phy_rarefied <- dar:::use_rarefy(metaHIV_phy, TRUE)

## Witout seed
# phy_rarefied <- dar:::use_rarefy(metaHIV_phy, "no_seed")
}
\keyword{internal}
