% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wilcox.R
\name{step_wilcox}
\alias{step_wilcox}
\alias{step_wilcox,Recipe-method}
\alias{step_wilcox,PrepRecipe-method}
\title{Wilcox analysis}
\usage{
step_wilcox(
  rec,
  norm_method = "compositional",
  max_significance = 0.05,
  p_adj_method = "BH",
  rarefy = FALSE,
  id = rand_id("wilcox")
)

\S4method{step_wilcox}{Recipe}(
  rec,
  norm_method = "compositional",
  max_significance = 0.05,
  p_adj_method = "BH",
  rarefy = FALSE,
  id = rand_id("wilcox")
)

\S4method{step_wilcox}{PrepRecipe}(
  rec,
  norm_method = "compositional",
  max_significance = 0.05,
  p_adj_method = "BH",
  rarefy = FALSE,
  id = rand_id("wilcox")
)
}
\arguments{
\item{rec}{A Recipe object. The step will be added to the sequence of
operations for this Recipe.}

\item{norm_method}{Transformation to apply. The options include:
'compositional' (ie relative abundance), 'Z', 'log10', 'log10p',
'hellinger', 'identity', 'clr', 'alr', or any method from the
vegan::decostand function.}

\item{max_significance}{The q-value threshold for significance.}

\item{p_adj_method}{Character. Specifying the method to adjust p-values for
multiple comparisons. Default is “BH” (Benjamini-Hochberg procedure).}

\item{rarefy}{Boolean indicating if OTU counts must be rarefyed. This
rarefaction uses the standard R sample function to resample from the
abundance values in the otu_table component of the first argument, physeq.
Often one of the major goals of this procedure is to achieve parity in
total number of counts between samples, as an alternative to other formal
normalization procedures, which is why a single value for the sample.size
is expected. If 'no_seed', rarefaction is performed without a set seed.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An object of class \code{Recipe}
}
\description{
Performs a wilcox test to determine features (be it Operational Taxanomic
Unit (OTU), species, etc.) that are differentially abundant between two or
more groups of multiple samples.
}
\examples{
data(metaHIV_phy)

## Init Recipe
rec <-
  recipe(metaHIV_phy, "RiskGroup2", "Phylum") |>
  step_subset_taxa(tax_level = "Kingdom", taxa = c("Bacteria", "Archaea")) |>
  step_filter_taxa(.f = "function(x) sum(x > 0) >= (0.4 * length(x))")

rec

## Define step with default parameters and prep
rec <-
  step_wilcox(rec) |>
  prep(parallel = FALSE)

rec

## Wearing rarefaction only for this step
rec <-
  recipe(metaHIV_phy, "RiskGroup2", "Species") |>
  step_wilcox(rarefy = TRUE)

rec
}
\seealso{
Other Diff taxa steps: 
\code{\link{step_aldex}()},
\code{\link{step_ancom}()},
\code{\link{step_corncob}()},
\code{\link{step_deseq}()},
\code{\link{step_lefse}()},
\code{\link{step_maaslin}()},
\code{\link{step_metagenomeseq}()}
}
\concept{Diff taxa steps}
