% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corncob.R
\name{step_corncob}
\alias{step_corncob}
\alias{step_corncob,Recipe-method}
\alias{step_corncob,PrepRecipe-method}
\title{corncob analysis}
\usage{
step_corncob(
  rec,
  phi.formula = stats::formula(~1),
  formula_null = stats::formula(~1),
  phi.formula_null = stats::formula(~1),
  link = "logit",
  phi.link = "logit",
  test = "Wald",
  boot = FALSE,
  B = 1000,
  filter_discriminant = TRUE,
  fdr_cutoff = 0.05,
  fdr = "fdr",
  log2FC = 0,
  rarefy = FALSE,
  id = rand_id("corncob")
)

\S4method{step_corncob}{Recipe}(
  rec,
  phi.formula = stats::formula(~1),
  formula_null = stats::formula(~1),
  phi.formula_null = stats::formula(~1),
  link = "logit",
  phi.link = "logit",
  test = "Wald",
  boot = FALSE,
  B = 1000,
  filter_discriminant = TRUE,
  fdr_cutoff = 0.05,
  fdr = "fdr",
  log2FC = 0,
  rarefy = FALSE,
  id = rand_id("corncob")
)

\S4method{step_corncob}{PrepRecipe}(
  rec,
  phi.formula = stats::formula(~1),
  formula_null = stats::formula(~1),
  phi.formula_null = stats::formula(~1),
  link = "logit",
  phi.link = "logit",
  test = "Wald",
  boot = FALSE,
  B = 1000,
  filter_discriminant = TRUE,
  fdr_cutoff = 0.05,
  fdr = "fdr",
  log2FC = 0,
  rarefy = FALSE,
  id = rand_id("corncob")
)
}
\arguments{
\item{rec}{A Recipe object. The step will be added to the sequence of
operations for this Recipe.}

\item{phi.formula}{An object of class formula without the response: a
symbolic description of the model to be fitted to the dispersion.}

\item{formula_null}{Formula for mean under null, without response.}

\item{phi.formula_null}{Formula for overdispersion under null, without
response.}

\item{link}{Link function for abundance covariates, defaults to "logit".}

\item{phi.link}{Link function for dispersion covariates, defaults to "logit".}

\item{test}{Character. Hypothesis testing procedure to use. One of "Wald" or
"LRT" (likelihood ratio test).}

\item{boot}{Boolean. Defaults to FALSE. Indicator of whether or not to use
parametric bootstrap algorithm. (See pbWald and pbLRT).}

\item{B}{Optional integer. Number of bootstrap iterations. Ignored if boot is
FALSE. Otherwise, defaults to 1000.}

\item{filter_discriminant}{Boolean. Defaults to TRUE. If FALSE, discriminant
taxa will not be filtered out.}

\item{fdr_cutoff}{Integer. Defaults to 0.05. Desired type 1 error rate.}

\item{fdr}{Character. Defaults to "fdr". False discovery rate control method,
see p.adjust for more options.}

\item{log2FC}{log2FC cutoff.}

\item{rarefy}{Boolean indicating if OTU counts must be rarefyed. This
rarefaction uses the standard R sample function to resample from the
abundance values in the otu_table component of the first argument, physeq.
Often one of the major goals of this procedure is to achieve parity in
total number of counts between samples, as an alternative to other formal
normalization procedures, which is why a single value for the sample.size
is expected. If 'no_seed', rarefaction is performed without a set seed.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An object of class \code{Recipe}
}
\description{
Corncob an individual taxon regression model that uses abundance tables and
sample data. corncob is able to model differential abundance and differential
variability, and addresses each of the challenges presented below:
}
\details{
\itemize{
\item different sequencing depth
\item excessive zeros from unobserved taxa
\item high variability of empirical relative abundances (overdispersion)
\item within-taxon correlation
\item hypothesis testing with categorical and continuous covariates
}
}
\examples{
data(metaHIV_phy)

## Init Recipe
rec <- 
  recipe(metaHIV_phy, "RiskGroup2", "Phylum") |>
  step_subset_taxa(tax_level = "Kingdom", taxa = c("Bacteria", "Archaea")) |>
  step_filter_taxa(.f = "function(x) sum(x > 0) >= (0.3 * length(x))")

rec

## Define step with default parameters and prep
rec <- 
  step_corncob(rec) |>
  prep(parallel = FALSE)
  
rec
}
\seealso{
Other Diff taxa steps: 
\code{\link{step_aldex}()},
\code{\link{step_ancom}()},
\code{\link{step_deseq}()},
\code{\link{step_lefse}()},
\code{\link{step_maaslin}()},
\code{\link{step_metagenomeseq}()},
\code{\link{step_wilcox}()}
}
\concept{Diff taxa steps}
