% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_data.R
\name{read_data}
\alias{read_data}
\alias{validate_otu}
\alias{validate_sample_data}
\alias{validate_tax_table}
\alias{validate_phyloseq}
\alias{read_phyloseq}
\alias{read_file}
\title{Loads Phyloseq data}
\usage{
read_data(data_path)

validate_otu(otu)

validate_sample_data(sample_data)

validate_tax_table(tax_table)

validate_phyloseq(phy, slots = c("sample_data", "tax_table"))

read_phyloseq(file_path)

read_file(file_path, ext = c(".txt|.csv|.tsv"))
}
\arguments{
\item{data_path}{List of length 1 or 3, with the paths of the input files.}
}
\value{
a phylseq-class object
}
\description{
This function returns a validated Phyloseq object by loading it directly from
a file with the .rds extension. Alternatively, this function can also take
three text files as input that will be used to construct and validate the
Phyloseq object: - Counts matrix with the otu_id in the first column. -
Taxonomic annotation matrix with the otu_id in the first column. - Metadata
annotation with sample_id in the first column.
}
\examples{
# From a phyloseq object saved with .rds extension.
system.file("extdata", "metaHIV_phy.rds", package = "dar") |>
  read_data()

# From the three components of a phyloseq object saved as a plain text.
data_path <- c(
  system.file("extdata", "metaHIV_counts.txt", package = "dar"),
  system.file("extdata", "metaHIV_metadata.txt", package = "dar"),
  system.file("extdata", "metaHIV_taxas.txt", package = "dar")
)

read_data(data_path)
}
\keyword{internal}
