% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/errorModels.R
\name{makeBinnedQualErrfun}
\alias{makeBinnedQualErrfun}
\title{Create a function that uses a piecewise linear fit to estimate error rates
from transition counts derived from binned quality score data. The binned 
quality scores are defined in the argument to this function call.}
\usage{
makeBinnedQualErrfun(binnedQ)
}
\arguments{
\item{binnedQ}{(Required). A vector of the binned quality scores that are
present in your sequencing data.}
}
\value{
This function returns a function.
The returned function accepts a matrix of observed transitions, 
with each transition corresponding to a row (eg. row 2 = A->C) and each column to a 
quality score (eg. col 31 = Q30). That function returns a matrix of estimated 
error rates of the same shape. 

The returned function has as required input the trans matrix, and returns
a numeric matrix with 16 rows and the same number of columns as trans.
The estimated error rates for each transition (row, eg. "A2C") and quality score
(column, eg. 31). See `loessErrfun` for a comparable function to the one that
is returned here.
}
\description{
Create a function that uses a piecewise linear fit to estimate error rates
from transition counts derived from binned quality score data. The binned 
quality scores are defined in the argument to this function call.
}
\examples{
derep1 <- derepFastq(system.file("extdata", "sam1F.fastq.gz", package="dada2"))
dada1 <- dada(derep1, err=tperr1)
novaBinnedErrfun <- makeBinnedQualErrfun(c(7, 17, 27, 40))
err.new <- novaBinnedErrfun(dada1$trans)

}
