% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCells.R
\name{plotCells}
\alias{plotCells}
\title{Function to visualize cell-level information on segmentation masks}
\usage{
plotCells(
  mask,
  object = NULL,
  cell_id = NULL,
  img_id = NULL,
  colour_by = NULL,
  outline_by = NULL,
  exprs_values = "counts",
  colour = NULL,
  ...
)
}
\arguments{
\item{mask}{a \code{\linkS4class{CytoImageList}} containing single-channel
\code{\linkS4class{Image}} objects (see section 'Segmentation mask object'
below).}

\item{object}{a \code{\linkS4class{SingleCellExperiment}} object.}

\item{cell_id}{character specifying the \code{colData(object)} entry, in
which the integer cell IDs are stored. These IDs should match the integer
pixel values in the segmentation mask object.}

\item{img_id}{character specifying the \code{colData(object)} and
\code{mcols(mask)} entry, in which the image IDs are stored (see section
'Linking the \code{SingleCellExperiment} and \code{CytoImageList} object'
below)}

\item{colour_by}{character or character vector specifying the features
(\code{rownames(object)}) or metadata (\code{colData(object)} entry) used
to colour individual cells. Cells can be coloured by single
\code{colData(object)} entries or by up to six features.}

\item{outline_by}{single character indicating the \code{colData(object)}
entry by which to outline individual cells.}

\item{exprs_values}{single character indicating which \code{assay(object)}
entry to use when visualizing feature counts.}

\item{colour}{a list with names matching the entries to \code{colour_by}
and/or \code{outline_by}. When setting the colour for continous features,
at least two colours need to be provided indicating the colours for minimum
and maximum values. When colouring discrete vectors, a colour for each
unique entry needs to be provided (see section 'Setting the colours' and
examples)}

\item{...}{Further arguments passed to \code{?"\link{plotting-param}"}}
}
\value{
a list if \code{return_images} and/or \code{return_plot} is TRUE
(see \code{?"\link{plotting-param}"}).
\itemize{
\item \code{plot}: a single plot object (\code{display = "all"}) or a list
of plot objects (\code{display = "single"})
\item \code{images}: a \code{\linkS4class{SimpleList}} object containing
three-colour \code{\linkS4class{Image}} objects.
}
}
\description{
This function takes a \code{\linkS4class{SingleCellExperiment}} and
\code{\linkS4class{CytoImageList}} object containing segmentation masks to
colour cells by marker expression or metadata.
}
\section{Segmentation mask object}{

In the \code{plotCells} function, \code{mask} refers to a
\code{\linkS4class{CytoImageList}} object that contains a single or multiple
segmentation masks in form of individual \code{\linkS4class{Image}} objects.
The function assumes that each object in the segmentation mask is a cell.
The key features of such masks include:
\itemize{
    \item each Image object contains only one channel
    \item pixel values are integers indicating the cells' IDs or 
    0 (background)
}
}

\section{Linking SingleCellExperiment and CytoImageList objects}{

To colour individual cells contained in the segmentation masks based on
features and metadata stored in the SingleCellExperiment object, an
\code{img_id} and \code{cell_id} entry needs to be provided. Image IDs are
matched between the \code{SingleCellExperiment} and \code{CytoImageList}
object via entries to the \code{colData(object)[,img_id]} and the
\code{mcols(mask)[,img_id]} slots. Cell IDs are matched between the
\code{SingleCellExperiment} and \code{CytoImageList} object via entries to
\code{colData(object)[,cell_id]} and the integer values of the segmentation
masks.
}

\section{Setting the colours}{

By default, features and metadata are coloured based on internally-set
colours. To set new colours, a \code{list} object must be provided. The names
of the object must correspond to the entries to \code{colour_by} and/or
\code{outline_by}. When setting the colours for continous expression values
or continous metadata entries, a vector of at least two colours need to be
specified. These colours will be passed onto \code{\link{colorRampPalette}}
for interpolation. Discrete metadata entries can be coloured by specifying a
named vector in which each entry corresponds to a unique entry to the
metadata vector.
}

\section{Subsetting the \code{CytoImageList} object}{

The \code{CytoImageList} object can be subsetted before calling the
\code{plotCells} function. In that case, only the selected images are
displayed.
}

\section{Subsetting the \code{SingleCellExperiment} object}{

The \code{SingleCellExperiment} object can be subsetted before calling the
\code{plotCells} function. In that case, only cells contained in the
\code{SingleCellExperiment} object are coloured/outlined.
}

\section{Colour scaling}{

When colouring features using the plotCells function, colours are scaled
between the minimum and maximum per feature across the full assay contained
in the SingleCellExperiment object. When subsetting images, cell-level
expression is not scaled across the subsetted images but the whole
SingleCellExperiment object. To avoid this, the SingleCellExperiment object
can be subsetted to only contain the cells that should be displayed before
plotting.
}

\examples{
data(pancreasMasks)
data(pancreasSCE)

# Visualize the masks
plotCells(pancreasMasks)

# Colour the masks based on averaged expression
plotCells(pancreasMasks, object = pancreasSCE, img_id = "ImageNb",
            cell_id = "CellNb", colour_by = c("CD99", "CDH"))

# Colour the masks based on metadata
plotCells(pancreasMasks, object = pancreasSCE, img_id = "ImageNb",
            cell_id = "CellNb", colour_by = "CellType")

# Outline the masks based on metadata
plotCells(pancreasMasks, object = pancreasSCE, img_id = "ImageNb",
            cell_id = "CellNb", colour_by = "CD99",
            outline_by = "CellType")

# Colour the masks based on arcsinh-transformed expression
plotCells(pancreasMasks, object = pancreasSCE, img_id = "ImageNb",
            cell_id = "CellNb", colour_by = "CD99",
            exprs_values = "exprs")

# Subset the images
cur_images <- getImages(pancreasMasks, 1:2)
plotCells(cur_images, object = pancreasSCE, img_id = "ImageNb",
            cell_id = "CellNb", colour_by = "CD99")

# Set colour
plotCells(pancreasMasks, object = pancreasSCE, img_id = "ImageNb",
            cell_id = "CellNb", colour_by = "CD99", outline_by = "CellType",
            colour = list(CD99 = c("black", "red"),
                            CellType = c(celltype_A = "blue",
                                        celltype_B = "green",
                                        celltype_C = "red")))

}
\seealso{
For further plotting parameters see \code{?"\link{plotting-param}"}
}
\author{
Nils Eling (\email{nils.eling@dqbm.uzh.ch})

Nicolas Damond (\email{nicolas.damond@dqbm.uzh.ch})
}
