% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CytoImageList-class.R, R/CytoImageList.R
\docType{class}
\name{CytoImageList-class}
\alias{CytoImageList-class}
\alias{CytoImageList}
\alias{coerce,ANY,CytoImageList-method}
\alias{coerce,list,CytoImageList-method}
\alias{show,CytoImageList-method}
\title{S4 class for list of images}
\usage{
CytoImageList(
  ...,
  on_disk = FALSE,
  h5FilesPath = NULL,
  BPPARAM = SerialParam()
)
}
\arguments{
\item{...}{A list of images (or coercible to a list) or individual images}

\item{on_disk}{Logical indicating if images in form of
\linkS4class{HDF5Array} objects (as .h5 files) should be stored on disk
rather than in memory.}

\item{h5FilesPath}{path to where the .h5 files for on disk representation
are stored. This path needs to be defined when \code{on_disk = TRUE}.
When files should only temporarily be stored on disk, please set
\code{h5FilesPath = getHDF5DumpDir()}}

\item{BPPARAM}{parameters for parallelised processing. 
This is only recommended for very large images. 
See \code{\linkS4class{MulticoreParam}} for information on how to use
multiple cores for parallelised processing.}
}
\value{
A CytoImageList object
}
\description{
This class facilitates the handling of multiple one- or multi-channel images.
It inherits from \code{\linkS4class{SimpleList}} setting
\code{elementType="Image"}. Therefore, each slot contains an either one- or
multi-dimensional array in form of an \code{\linkS4class{Image}} object.
}
\details{
Similar to the \code{\linkS4class{Image}} class, the first two
dimensions of each entry indicate the spatial dimension of the image. These
can be different for each entry. The third dimension indicates the number
of channels per Image. Each entry in the CytoImageList class object must
contain the same number of channels. Here, each channel represents pixel
values indicating measurement intensities or in case of segmentation masks
the cells' ID. The CytoImageList class therefore only supports a Grayscale
colormode (see \code{\link{colormode}}) representation of each
individual image.

The class further contains an \code{elementMetadata} slot that
stores image-level meta information. This slot should be accessed using the
\code{\link{mcols}} accessor function.
}
\section{Restrictions on entry names}{

The CytoImageList class only supports unique entry names to avoid duplicated
images. Names of a CytoImageList object can be get and set via
\code{names(x)}, where \code{x} is a CytoImageList object. Furthermore, only
named or unnamed CytoImageList objects are allowed. Partially named objects
causing empty or NA names return an error.
}

\section{Coercion}{

Coercion to and from list, \code{\linkS4class{SimpleList}} and
\code{\linkS4class{List}}:
\describe{
\item{as.list(x), as(x, "SimpleList"),
as(x, "SimpleList"):}{Coercion from a CytoImageList object \code{x}}
\item{as(x, "CytoImageList"):}{Coercion from a list, SimpleList or List
object \code{x} to anCytoImageList object}}
}

\section{Looping}{

While \code{\link[base]{lapply}} and \code{\link[base]{mapply}} return
regular list objects, \code{\link{endoapply}} and
\code{\link{mendoapply}} return CytoImageList objects.
}

\section{On disk representation}{

When setting \code{on_disk = TRUE} and specifying the \code{h5FilesPath}, 
images are stored on disk. To convert back to an in-memory 
\code{CytoImageList} object, one can call 
\code{CytoImageList(on_disk_IL, on_disk = FLASE)}.
}

\examples{
# Creation of CytoImageList
u <- matrix(rbinom(100, 10, 0.5), ncol=10, nrow=10)
v <- matrix(rbinom(100, 10, 0.5), ncol=10, nrow=10)
IL1 <- CytoImageList(image1 = Image(u), image2 = Image(v))

# Coercion
as.list(IL1)
as(IL1, "SimpleList")
as(list(image1 = Image(u), image2 = Image(v)), "CytoImageList")

# On disk representation
IL1 <- CytoImageList(image1 = Image(u), image2 = Image(v),
                     on_disk = TRUE, 
                     h5FilesPath = HDF5Array::getHDF5DumpDir())

}
\seealso{
\code{\linkS4class{Image}}, for further image analysis tools.

\code{\linkS4class{SimpleList}}, for basics functions to handle SimpleList
objects

\code{?\link{loadImages}}, for reading images into a CytoImageList
object

\code{?"\link{CytoImageList-naming}"}, for setting and getting image and
channel names

\code{?"\link{CytoImageList-subsetting}"}, for subsetting and
accessor functions
}
\author{
Nils Eling (\email{nils.eling@dqbm.uzh.ch})
}
