% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/AllslotAccessors.R
\docType{methods}
\name{CytoKData}
\alias{CytoKData}
\alias{CytoKData,CytoK-method}
\title{Generic function that returns the CytoK Data}
\usage{
CytoKData(object)

\S4method{CytoKData}{CytoK}(object)
}
\arguments{
\item{object}{an object of class \code{CytoK}.}
}
\value{
Original data object passed to \code{CytoK}.
}
\description{
Given a CytoK object, this function returns the
CytoK Data

Accessors for the 'CytoKData'
slot of a CytoK object.
}
\examples{
data <- cbind(matrix(rnorm(1200,mean=2, sd=1.5),
nrow=200, ncol=6), matrix(rnorm(1200,mean=5, sd=1.9),
nrow=200, ncol=6))
data_CytoK <- CytoK(object=data,
group_factor = rep(c(0,1), each=6), lowerRho=2,
upperRho=12,gridRho=4,alpha = 0.05,
featureVars = NULL)
CytoKData(data_CytoK)

}
