% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drugage_annot.R
\name{processDrugage}
\alias{processDrugage}
\title{Process Source DrugAge Dataset}
\usage{
processDrugage(dest_file = "drugage_id_mapping.tsv", verbose = TRUE)
}
\arguments{
\item{dest_file}{character(1), file path to the generated DrugAge annotation 
tabular file with id mappings. The default will write the file named as
"drugage_id_mapping.tsv" to user's current working directory.}

\item{verbose}{logical(1), If descriptive message and list of issues should be 
included as output}
}
\value{
write the default 'drugage_id_mapping.tsv' file to user's current working
directory or the file path defined by users to the \code{dest_dafile} argument.
}
\description{
This function processes the source DrugAge datasets by adding the ChEMBL, 
PubChem and DrugBank id mapping information to the source DrugAge table 
which only has compound names without id mapping information. Source file of 
DrugAge is linked here: \url{http://genomics.senescence.info/drugs/dataset.zip}
}
\details{
This function only annotates compound names that have ChEMBL 
ids from the ChEMBL database (version 24). The missing IDs were added 
manually. A semi-manual approach was to use this web service: 
\url{https://cts.fiehnlab.ucdavis.edu/batch}. After the semi-manual process,
the left ones were manually mapped to ChEMBL, PubChem and DrugBank ids. 
The mixed items were commented.
}
\examples{
library(ChemmineR)
\dontrun{
processDrugage(dest_file="drugage_id_mapping.tsv")
# Now the missing IDs need to be added manually. A semi-manual approach is to 
# use this web service: https://cts.fiehnlab.ucdavis.edu/batch
}
}
