% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crisprServer.R
\name{crisprServer}
\alias{crisprServer}
\title{Server component for crisprShiny App}
\usage{
crisprServer(id, guideSet, geneModel, title = NULL, useFilterPresets = TRUE)
}
\arguments{
\item{id}{Module ID.}

\item{guideSet}{A GuideSet object.}

\item{geneModel}{A GRangesList object obtained using
\code{crisprDesign::TxDb2GRangesList}.}

\item{title}{Optional title to display at head of app.}

\item{useFilterPresets}{Whether to use preset filter values on app launch.
See details section for \code{?crisprShiny}.}
}
\value{
Shiny module server component.
}
\description{
Server component for crisprShiny App. Not intended for direct
use. (intended to be passed as server component of module in shinyApp function)
}
\examples{
library(crisprShiny)
ui <- function(id){
    fluidPage(
        crisprUI(id)
    )
}

server <- function(id, gs){
    function(input, output, session){
        observeEvent(gs, {
            crisprServer(
                id,
                guideSet=gs,
                geneModel=NULL,
                useFilterPresets=TRUE
            )
        })
    }
}

myApp <- function(gs){
    shinyApp(ui=ui("id"), server=server("id", gs))
}

if (interactive()){
    data("guideSetExample_basic", package="crisprShiny")
    myApp(guideSetExample_basic)
}
    
}
