% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getEnPAMGBScores.R
\name{getEnPAMGBScores}
\alias{getEnPAMGBScores}
\title{Calculate on-target sgRNA activity scores for enCas12a using enPAM+GB}
\usage{
getEnPAMGBScores(sequences, fork = FALSE)
}
\arguments{
\item{sequences}{Character vector of 34bp sequences needed for enPAM+GB
scoring, see details below.}

\item{fork}{Set to \code{TRUE} to preserve changes to the R
configuration within the session.}
}
\value{
\strong{getEnPAMGBScores} returns a data.frame with \code{sequence}
    and \code{score} columns.
}
\description{
Calculate on-target sgRNA activity scores for
    CRISPR/Cas12a-induced knockout using the enPAM+GB scoring method.
    Currently not supported on Windows machines.
}
\details{
The input sequences for enPAM+GB scoring require 4 nucleotides
    upstream of the protospacer sequence, the protospacer sequence
    itself (4bp PAM sequence + 23bp spacer sequence) and 3 nucleootides 
    downstream of the protospacer sequence, for a total of 34 nucleotides.
    Both canonical and non-canonical PAM sequences can be provided.
}
\examples{
if (interactive()){
flank5 <- "CATG" #4bp
pam    <- "TTTT" #4bp
spacer <- "TTTGGGAACCAATCGATAATCAC" #23bp
flank3 <- "ATT" #3bp
input  <- paste0(flank5, pam, spacer, flank3) 
results <- getEnPAMGBScores(input)
}
}
\references{
DeWeirdt, P.C., Sanson, K.R., Sangree, A.K. et al. Optimization of AsCas12a
    for combinatorial genetic screens in human cells.
    Nat Biotechnol 39, 94–104 (2021).
    \url{https://doi.org/10.1038/s41587-020-0600-6}.
}
\author{
Jean-Philippe Fortin
}
