% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeDF.R
\name{defineTableDesc}
\alias{defineTableDesc}
\title{Define table descriptions}
\usage{
defineTableDesc(
  calculateStatistics,
  subsampleSize,
  kfrac,
  kmin,
  obstype,
  aspect,
  minvalue,
  maxvalue,
  permutationPvalues,
  nPermutations,
  nDatasets
)
}
\arguments{
\item{calculateStatistics}{Whether or not statistics and p-values are
calculated}

\item{subsampleSize}{The number of observations for which certain
(time-consuming) statistics will be calculated}

\item{kmin, kfrac}{For statistics that require the extraction of k nearest
neighbors of a given point, the number of neighbors will be max(kmin, kfrac
* nrow(df))}

\item{obstype}{The type of observation (e.g., sample, feature, sample pair)}

\item{aspect}{The name of the aspect of interest}

\item{minvalue, maxvalue}{The minimal and maximal value of the aspect of
interest, used for scaling of the x axis when calculating the area between
the eCDFs}

\item{permutationPvalues}{Whether or not to calculate p-values of statistics
via permutation}

\item{nPermutations}{The number of permutations (only used if
permutationPvalues = TRUE)}

\item{nDatasets}{The number of data sets that are being compared}
}
\value{
A list with two text strings in markdown format: one for tables based
  on a single data column, and one for tables based on two data columns
}
\description{
Generate the text that describes the content of the tables generated by
\code{makeDF}.
}
\author{
Charlotte Soneson
}
\keyword{internal}
