% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_COSMOS_signaling_to_metabolism.R
\name{run_COSMOS_signaling_to_metabolism}
\alias{run_COSMOS_signaling_to_metabolism}
\title{run COSMOS signaling to metabolism}
\usage{
run_COSMOS_signaling_to_metabolism(
  data,
  CARNIVAL_options = default_CARNIVAL_options("lpSolve")
)
}
\arguments{
\item{data}{\code{\link{cosmos_data}} object.  Use the
\code{\link{preprocess_COSMOS_signaling_to_metabolism}} function to create
an instance.}

\item{CARNIVAL_options}{List that controls the options of CARNIVAL. See 
details in \code{\link{default_CARNIVAL_options}}.}
}
\value{
List with the following elements:
  \describe{
    \item{\code{weightedSIF}}{The averaged networks found by 
    optimization in a format of a Simple Interaction network, i.e. each row 
    codes an edge}
    \item{\code{N_networks}}{Number of solutions found by the 
    optimization}
    \item{\code{nodesAttributes}}{Estimated node properties}
    \item{\code{individual_networks}}{List of optimial networks found}
    \item{\code{individual_networks_node_attributes}}{Node activity in each
    network}
  }
}
\description{
Runs COSMOS from signaling to metabolism.  This function uses CARNIVAL to find
a subset of the prior knowledge network based on optimisation that (1) 
includes the most measured and input nodes and (2) which is in agreement with
the data.  Use \code{\link{preprocess_COSMOS_signaling_to_metabolism}} to
prepare inputs, measurements and prior knowledge network.
}
\examples{
data(toy_network)
data(toy_signaling_input)
data(toy_metabolic_input)
data(toy_RNA)
test_for <- preprocess_COSMOS_signaling_to_metabolism(meta_network = toy_network,
                             signaling_data = toy_signaling_input,
                             metabolic_data = toy_metabolic_input,
                             diff_expression_data = toy_RNA,
                             maximum_network_depth = 15,
                             remove_unexpressed_nodes = TRUE,
                             CARNIVAL_options = default_CARNIVAL_options("lpSolve"))

test_result_for <- run_COSMOS_signaling_to_metabolism(data = test_for,
                             CARNIVAL_options = default_CARNIVAL_options("lpSolve"))
}
\seealso{
\code{\link{preprocess_COSMOS_metabolism_to_signaling}},  
  \code{\link[CARNIVAL]{runCARNIVAL}}, \code{\link{cosmos_data}}
}
