% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scal_var.R
\name{scal_var}
\alias{scal_var}
\title{Generate a scaled variance plot for an integrative embedding}
\usage{
scal_var(
  inp,
  batchvec = NULL,
  pcs = seq(3),
  returngg = FALSE,
  showplot = TRUE,
  plot_subtitle = NULL
)
}
\arguments{
\item{inp}{corralm object or matrix; embedding to compute scaled variances}

\item{batchvec}{vector; batch labels (can be numeric or char). Defaults to `NULL`, which is appropriate for using a corralm object. If using an embedding matrix for inp, then this argument must be given and length must correspond to number of rows in `inp`.}

\item{pcs}{numeric; vector of which PCs should be shown. Defaults to 1:3}

\item{returngg}{boolean; whether or not to return a \code{\link{ggplot2}} object, defaults \code{FALSE}}

\item{showplot}{boolean; whether or not to show the plot, defaults \code{TRUE}}

\item{plot_subtitle}{string; the text that should show in the subtitle for the plot. defaults to NULL}
}
\value{
N/A or a ggplot object
}
\description{
Generate a scaled variance plot for an integrative embedding
}
\examples{
dat <- matrix(rnorm(10000), ncol = 50)
bv <- rep(seq(4),c(10,30,60,100))
scal_var(dat,bv, pcs = seq(4))
}
