% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_DE.R
\name{multi_de_pairs}
\alias{multi_de_pairs}
\title{Batch - multiDE analysis of many comparisons}
\usage{
multi_de_pairs(summarized = NULL, paired = "unpaired",
  intercept = NULL, adjust_method = "BH", EDASeq_method = "upper",
  norm_method = "EDASeq", ruv_correct = FALSE,
  ensembl_annotate = NULL, gtf_annotate = NULL, plot_dir = NULL,
  output_voom = NULL, output_edger = NULL, output_deseq = NULL,
  output_combined = NULL, verbose = FALSE, legend = TRUE,
  label = TRUE)
}
\arguments{
\item{summarized}{A "RangedSummarizedExperiment" object with included groups
to be analysed. For format specifications see ?buildSummarized. E.g.
accessible as "summarized$group". Groups are used to automate colouring of
samples in unsupervised analyses. Default = NULL}

\item{paired}{Are the sample paired? If "paired" a paired statistical
analysis by including factors as pairs described in the "pairs" column of the
"RangedSummarizedExperiment" object in the model (accessible as
summarized$pairs). Options are "unpaired" or "paired". Default="unpaired"}

\item{intercept}{Optional ability to set the base term for fitting the model.
This is not necessary as all pairs are computed automatically. The base
term, if set, must match the name of s group in "summarized$group". Default 
= NULL}

\item{adjust_method}{Method used for multiple comparison adjustment of
p-values. Options are: "holm", "hochberg", "hommel", "bonferroni", "BH",
"BY", "fdr" or "none". See ?p.adjust.methods for a details description and
references. Default = "BH"}

\item{EDASeq_method}{Method for normalisation (applies to QC results using 
EDASeq and RUV when EDASeq is selected). Options are:"median","upper","full".
Default = "upper"}

\item{norm_method}{Methods for normalisation. Options are: "EDASeq" or 
"all_defaults". When "all_defaults" is selected, this will use all default 
normalisation methods for differential expression, EDASeq for QC, and edgeR 
"upperquantile" for determining RUV residuals (as per RUVSeq vignette). When 
"EDASeq" is selected, this will use EDASeq normalisation throughout. EDASeq 
normalisation method is selected using "EDASeq_method". Default = "EDASeq".}

\item{ruv_correct}{Remove Unwanted Variation (RUV)? See ?RUVr for
description. Currently only RUVr, which used the residuals is enabled and one
factor of variation is determined. If set to TRUE and a "plot_dir" is
provided, additional plots after RUV correction and the RUV residuals will
be reported. Residuals are obtained through fitting a generalised linear
model (GLM) using EdgeR. Residuals are then incorporated into the
SummarizedExperiment object and all models for DE analysis. Options = TRUE,
FALSE. Default = FALSE.}

\item{ensembl_annotate}{If the dataset has been mapped to ensembl transcript
identifiers, obtain additional annotation of the ensembl transcripts. A R 
Genome Wide Annotation object e.g. org.Mm.eg.db for mouse or org.Hs.eg.db for
human must be provided. Default = NULL}

\item{gtf_annotate}{Full path to a gtf file describing the transcripts. If 
provided will obtain gene symbols from gtf file. If a ensembl_annotate object
is also provided, this will extract annotations based on the symbols 
extracted from the GTF file. It is recommended to provide both a gtf file and
a tx_db for better annotation results. Default = NULL}

\item{plot_dir}{Full path to directory for output of plots (pdf files). See
?diag_plots for more details. Default = NULL}

\item{output_voom}{If you wish to output the results of the Voom analysis,
provide a full path to directory for output of files. Default = NULL}

\item{output_edger}{If you wish to output the results of the EdgeR analysis,
provide a full path to directory for output of files. Default = NULL}

\item{output_deseq}{If you wish to output the results of the DEseq2 analysis,
provide a full path to directory for output of files. Default = NULL}

\item{output_combined}{consensusDE will report the results of Voom, EdgeR
and DEseq2 as a combined report. If you wish to output the results of the
COMBINED analysis, provide a full path to directory for output of files. In
addition to the combined data, it will also output the raw count and
normalised data to the same directory. Default = NULL}

\item{verbose}{Verbosity ON/OFF. Default=FALSE}

\item{legend}{Include legend in plots? Legend is based on group data in
summarized Options: TRUE, FALSE. Default = TRUE}

\item{label}{Include point labels in plots? Points are based on ID column
after DE analysis from merged results. Options: TRUE, FALSE. Default = TRUE}
}
\value{
A list of all the comparisons conducted.
## See vignette for more details.
}
\description{
Given a summarized experiment generated using buildSummarized()
this function will automatically perform differential expression (DE)
analysis for all possible groups using 3 different methods 1) EdgeR, 2) Voom
and 3) DEseq2. It will also output 10x diagnostic plots automatically, if the
plotting options are selected (see ?diag_plots for more details).
}
\examples{
## Load the example data set and attach - see vignette for more details
## The example below will perfrom DE analysis on all pairs of data
library(airway)
data(airway)
## Name groups of the data.
colData(airway)$group <- colData(airway)$dex
## Identify file locations
colData(airway)$file <- rownames(colData(airway))
#' ## Filter low count data:
airway_filter <- buildSummarized(summarized = airway,
                                 filter = TRUE)
## for illustration, we only use random sample of 1000 transcripts
set.seed(1234)
airway_filter <- sample(airway_filter, 1000)
## Run multi_de_pairs() with-out RUV correction
## To run with RUV correction, use ruv_correct = TRUE
all_pairs_airway <- multi_de_pairs(summarized = airway_filter,
                                   ruv_correct = FALSE,
                                   paired = "unpaired")

}
