% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateRmdCodeDiffExp.R
\name{EBSeq.createRmd}
\alias{EBSeq.createRmd}
\title{Generate a .Rmd file containing code to perform differential expression analysis with EBSeq}
\usage{
EBSeq.createRmd(data.path, result.path, codefile, norm.method)
}
\arguments{
\item{data.path}{The path to a .rds file containing the \code{compData} object that will be used for the differential expression analysis.}

\item{result.path}{The path to the file where the result object will be saved.}

\item{codefile}{The path to the file where the code will be written.}

\item{norm.method}{The between-sample normalization method used to compensate for varying library sizes and composition in the differential expression analysis. Possible values are \code{"median"} and \code{"quantile"}.}
}
\value{
The function generates a .Rmd file containing the differential expression code. This file can be executed using e.g. the \code{knitr} package.
}
\description{
A function to generate code that can be run to perform differential expression analysis of RNAseq data (comparing two conditions) using the \code{EBSeq} package. The code is written to a .Rmd file. This function is generally not called by the user, the main interface for performing differential expression analysis is the \code{\link{runDiffExp}} function.
}
\details{
For more information about the methods and the meaning of the parameters, see the \code{EBSeq} package and the corresponding publications.
}
\examples{
try(
if (require(EBSeq)) {
tmpdir <- normalizePath(tempdir(), winslash = "/")
mydata.obj <- generateSyntheticData(dataset = "mydata", n.vars = 1000,
                                    samples.per.cond = 5, n.diffexp = 100,
                                    output.file = file.path(tmpdir, "mydata.rds"))
runDiffExp(data.file = file.path(tmpdir, "mydata.rds"), result.extent = "EBSeq",
           Rmdfunction = "EBSeq.createRmd",
           output.directory = tmpdir, norm.method = "median")
}
)
}
\references{
Leng N, Dawson JA, Thomson JA, Ruotti V, Rissman AI, Smits BMG, Haag JD, Gould MN, Stewart RM and Kendziorski C (2013): EBSeq: An empirical Bayes hierarchical model for inference in RNA-seq experiments. Bioinformatics
}
\author{
Charlotte Soneson
}
