% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.combi.R
\name{print.combi}
\alias{print.combi}
\title{Print an overview of a fitted combi x}
\usage{
\method{print}{combi}(x, ...)
}
\arguments{
\item{x}{a fitted combi x}

\item{...}{Further arguments, currently ignored}
}
\value{
An overview of the number of dimensions, views and parameters,
type of ordination and importance parameters
}
\description{
Print an overview of a fitted combi x
}
\examples{
data(Zhang)
\dontrun{
#Unconstrained
microMetaboInt = combi(
list("microbiome" = zhangMicrobio, "metabolomics" = zhangMetabo),
distributions = c("quasi", "gaussian"), compositional = c(TRUE, FALSE),
logTransformGaussian = FALSE, verbose = TRUE)
#Constrained
microMetaboIntConstr = combi(
    list("microbiome" = zhangMicrobio, "metabolomics" = zhangMetabo),
    distributions = c("quasi", "gaussian"), compositional = c(TRUE, FALSE),
    logTransformGaussian = FALSE, covariates = zhangMetavars, verbose = TRUE)}
    #Load the fits
load(system.file("extdata", "zhangFits.RData", package = "combi"))
print(microMetaboInt)
print(microMetaboIntConstr)
#Or simply
microMetaboInt
}
