% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inflPlot.R
\name{inflPlot}
\alias{inflPlot}
\title{A ggplot line plot showing the influences}
\usage{
inflPlot(
  modelObj,
  plotType = ifelse(length(modelObj$data) <= 2, "pointplot", "boxplot"),
  pointFun = "sum",
  lineSize = 0.07,
  Dim = 1,
  samples = seq_len(nrow(if (is.null(modelObj$covariates)) modelObj$latentVars else
    modelObj$alphas)),
  ...
)
}
\arguments{
\item{modelObj}{The fitted data integration}

\item{plotType}{The type of plot requested, see details}

\item{pointFun}{The function to calculate the summary measure to be plotted}

\item{lineSize}{The line size}

\item{Dim}{The dimension required}

\item{samples}{index vector of which samples to be plotted}

\item{...}{additional arguments passed on to the influence() function}
}
\value{
A ggplot object
}
\description{
A ggplot line plot showing the influences
}
\details{
The options for plotType are: "pointPlot": Dot plot of total influence
 per view and sample, "boxplot": plot boxplot of influence of all
  observations per view and sample, "boxplotSingle": boxplot of log absolute
   total influence per view, "lineplot": line plot of total influence
 per view and sample. In the pointplot, dots crosses represent parameter estimates
}
\examples{
\donttest{
data(Zhang)
#Unconstrained
microMetaboInt = combi(
list("microbiome" = zhangMicrobio, "metabolomics" = zhangMetabo),
distributions = c("quasi", "gaussian"), compositional = c(TRUE, FALSE),
logTransformGaussian = FALSE, verbose = TRUE)
#Constrained
microMetaboIntConstr = combi(
    list("microbiome" = zhangMicrobio, "metabolomics" = zhangMetabo),
    distributions = c("quasi", "gaussian"), compositional = c(TRUE, FALSE),
    logTransformGaussian = FALSE, covariates = zhangMetavars, verbose = TRUE)}
load(system.file("extdata", "zhangFits.RData", package = "combi"))
inflPlot(microMetaboInt)
#Constrained
inflPlot(microMetaboIntConstr)
}
