% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractCoords.R
\name{extractCoords}
\alias{extractCoords}
\title{Extract coordinates from fitted object}
\usage{
extractCoords(modelObj, Dim)
}
\arguments{
\item{modelObj}{The fitted model}

\item{Dim}{the required dimensions}
}
\value{
A list with components (matrices with two columns)
\item{latentData}{The latent variables}
\item{featureData}{The feature parameters}
\item{varData}{The variables}
}
\description{
Extract coordinates from fitted object
}
\examples{
data(Zhang)
\dontrun{
#Unconstrained
microMetaboInt = combi(
list("microbiome" = zhangMicrobio, "metabolomics" = zhangMetabo),
distributions = c("quasi", "gaussian"), compositional = c(TRUE, FALSE),
logTransformGaussian = FALSE, verbose = TRUE)
}
    #Load the fits
load(system.file("extdata", "zhangFits.RData", package = "combi"))
extractCoords(microMetaboInt, Dim = c(1,2))
}
