% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util3_SplitCpGsSubregionsDataFrameToList.R
\name{SplitCpGDFbyRegion}
\alias{SplitCpGDFbyRegion}
\title{Split CpG dataframe by Subregion}
\usage{
SplitCpGDFbyRegion(
  CpGsSubregions_df,
  genome = c("hg19", "hg38"),
  arrayType = c("450k", "EPIC"),
  manifest_gr = NULL,
  returnAllCpGs = TRUE
)
}
\arguments{
\item{CpGsSubregions_df}{data frame with CpG and subregion number}

\item{genome}{Human genome of reference: hg19 or hg38}

\item{arrayType}{Type of array: 450k or EPIC}

\item{manifest_gr}{A GRanges object with the genome manifest (as returned by
\code{\link[ExperimentHub]{ExperimentHub}} or by
\code{\link{ImportSesameData}}). This function by default ignores this
argument in favour of the \code{genome} and \code{arrayType} arguments.}

\item{returnAllCpGs}{indicates if outputting all the CpGs in the region when
there is not a contiguous comethylated region or only the CpGs in the
contiguous comethylated regions}
}
\value{
a list of comethylated subregions CpGs for a pre-defined region
}
\description{
Split a dataframe of CpGs and comethylated subregions to a list
  of CpGs in each subregion
}
\examples{
   data(betaMatrix_ex4)
   CpGs_df <- MarkComethylatedCpGs(betaCluster_mat = betaMatrix_ex4)
   CpGsSubregions_df <- FindComethylatedRegions(CpGs_df)

   SplitCpGDFbyRegion(
     CpGsSubregions_df,
     genome = "hg19",
     arrayType = "450k"
   )

}
\keyword{internal}
