% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CpGsInfoOneRegion.R
\name{CpGsInfoOneRegion}
\alias{CpGsInfoOneRegion}
\title{Test Associations Between a Region and Phenotype}
\usage{
CpGsInfoOneRegion(
  regionName_char,
  region_gr = NULL,
  betas_df,
  pheno_df,
  contPheno_char,
  covariates_char = NULL,
  genome = c("hg19", "hg38"),
  arrayType = c("450k", "EPIC"),
  manifest_gr = NULL
)
}
\arguments{
\item{regionName_char}{character string of location information for a genomic
region, specified in the format of \code{"chrxx:xxxxxx-xxxxxx"}}

\item{region_gr}{An object of class \code{\link[GenomicRanges]{GRanges}} with
location information for one region. If this argument is NULL, then the 
region in \code{regionName_char} is used.}

\item{betas_df}{data frame of beta values with row names = CpG IDs, column
names = sample IDs}

\item{pheno_df}{a data frame with phenotype and covariate variables, with
variable "Sample" for sample IDs.}

\item{contPheno_char}{character string of the continuous phenotype to be
tested against methylation values}

\item{covariates_char}{character vector of covariate variables names}

\item{genome}{human genome of reference hg19 (default) or hg38}

\item{arrayType}{Type of array, can be "450k" or "EPIC"}

\item{manifest_gr}{A GRanges object with the genome manifest (as returned by
\code{\link[ExperimentHub]{ExperimentHub}} or by
\code{\link{ImportSesameData}}). This function by default ignores this
argument in favour of the \code{genome} and \code{arrayType} arguments.}
}
\value{
a data frame with location of the genomic region (Region), CpG ID
  (cpg), chromosome (chr), position (pos), results for testing association of
  methylation in individual CpGs with continuous phenotype (slopeEstimate,
  slopePval) and annotations for the region.
}
\description{
Test associations of individual CpGs in a genomic region with a
  continuous phenotype
}
\details{
This function implements linear models that test association between
  methylation values in a genomic region with a continuous phenotype. Note
  that methylation M values are used as regression outcomes in these models.
  The model for each CpG is:

  \code{methylation M value ~ contPheno_char + covariates_char}
}
\examples{
   data(betasChr22_df)
   data(pheno_df)
   myRegion_gr <- RegionsToRanges("chr22:18267969-18268249")

   CpGsInfoOneRegion(
     region_gr = myRegion_gr,
     betas_df = betasChr22_df,
     pheno_df = pheno_df,
     contPheno_char = "stage",
     covariates_char = c("age.brain", "sex"),
     arrayType = "450k"
   )

}
