% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalizeChromosomes.R
\name{normalizeChromosomes}
\alias{normalizeChromosomes}
\title{Normalization of NGS data.}
\usage{
normalizeChromosomes(X, chr, normType = "poisson", sizeFactor = "mean",
  qu = 0.25, quSizeFactor = 0.75, ploidy)
}
\arguments{
\item{X}{Matrix of positive real values, where
columns are interpreted as samples and rows as genomic regions. An entry is
the read count of a sample in the genomic region. Alternatively this can be
a GRanges object containing the read counts as values.}

\item{chr}{Character vector that has as many elements as "X" has rows. The
vector assigns each genomic segment to a reference sequence (chromosome).}

\item{normType}{Type of the normalization technique. Each samples'
read counts are scaled such that the total number of reads are comparable across 
samples.
If this parameter is set to the value "mode", 
the read counts are scaled such that each samples'
most frequent value (the "mode") is equal after normalization. 
Accordingly for the other options are "mean","median","poisson", "quant", and "mode". 
Default = "poisson".}

\item{sizeFactor}{By this parameter one can decide to how the size factors 
are calculated.
Possible choices are the the mean, median or mode coverage ("mean", "median", "mode") or any quantile 
("quant").}

\item{qu}{Quantile of the normType if normType is set to "quant" .Real value between 0 and 1. Default = 0.25.}

\item{quSizeFactor}{Quantile of the sizeFactor if sizeFactor is set to "quant".
0.75 corresponds to "upper quartile normalization". Real value between 0 and 1. Default = 0.75.}

\item{ploidy}{An integer value for each sample or each column in the read
count matrix. At least two samples must have a ploidy of 2. Default = "missing".}
}
\value{
A data matrix of normalized read counts with the same dimensions 
as the input matrix X.
}
\description{
Normalize quantitative NGS data in order to make counts comparable over
samples, i.e., correcting for different library sizes or coverages. 
Scales each samples' reads such that the coverage is even for 
all samples after normalization.
}
\examples{
data(cn.mops)
X.norm <- normalizeChromosomes(X)
}
\author{
Guenter Klambauer \email{klambauer@bioinf.jku.at}
}
