% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{feature_select_PCA}
\alias{feature_select_PCA}
\title{Returns a list of variable genes based on PCA}
\usage{
feature_select_PCA(
  mat = NULL,
  pcs = NULL,
  n_pcs = 10,
  percentile = 0.99,
  if_log = TRUE
)
}
\arguments{
\item{mat}{Expression matrix. Rownames are genes,
colnames are single cell cluster name, and
values are average single cell expression (log transformed).}

\item{pcs}{Precalculated pcs if available, will skip over processing on mat.}

\item{n_pcs}{Number of PCs to selected gene loadings from.
See the explore_PCA_corr.Rmd vignette for details.}

\item{percentile}{Select the percentile of absolute values of
PCA loadings to select genes from. E.g. 0.999 would select the
top point 1 percent of genes with the largest loadings.}

\item{if_log}{whether the data is already log transformed}
}
\value{
vector of genes
}
\description{
Extract genes, i.e. "features", based on the top
loadings of principal components
formed from the bulk expression data set
}
\examples{
feature_select_PCA(
    cbmc_ref,
    if_log = FALSE
)
}
