% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gseAnalyzer.R
\name{gseMKEGG}
\alias{gseMKEGG}
\title{gseMKEGG}
\usage{
gseMKEGG(
  geneList,
  organism = "hsa",
  keyType = "kegg",
  exponent = 1,
  minGSSize = 10,
  maxGSSize = 500,
  eps = 1e-10,
  pvalueCutoff = 0.05,
  pAdjustMethod = "BH",
  verbose = TRUE,
  seed = FALSE,
  by = "fgsea",
  ...
)
}
\arguments{
\item{geneList}{order ranked geneList}

\item{organism}{supported organism listed in 'https://www.genome.jp/kegg/catalog/org_list.html'}

\item{keyType}{one of "kegg", 'ncbi-geneid', 'ncib-proteinid' and 'uniprot'}

\item{exponent}{weight of each step}

\item{minGSSize}{minimal size of each geneSet for analyzing}

\item{maxGSSize}{maximal size of genes annotated for testing}

\item{eps}{This parameter sets the boundary for calculating the p value.}

\item{pvalueCutoff}{pvalue Cutoff}

\item{pAdjustMethod}{pvalue adjustment method}

\item{verbose}{print message or not}

\item{seed}{logical}

\item{by}{one of 'fgsea' or 'DOSE'}

\item{...}{other parameter}
}
\value{
gseaResult object
}
\description{
Gene Set Enrichment Analysis of KEGG Module
}
\author{
Yu Guangchuang
}
