% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01.BED6WithSeq2GRangesSeq.R
\name{BED6WithSeq2GRangesSeq}
\alias{BED6WithSeq2GRangesSeq}
\title{Covert (extended) BED6 file to a GRanges object}
\usage{
BED6WithSeq2GRangesSeq(
  file,
  skip = 1L,
  withSeq = TRUE,
  upstream.seq.ind = 7L,
  downstream.seq.ind = 8L
)
}
\arguments{
\item{file}{A character(1) vector, representing a path to a extended BED file
containing at least six columns in the order of chrom, chromStart, strEnd, 
name, score and strand. The strand information must be designated as "+",
or "-". Optional fields--upstream sequences (including pA sites) and 
downstream sequences of pA sites--are allowed. For more details about the BED
format, see https://genome.ucsc.edu/FAQ/FAQformat.html#format1.}

\item{skip}{A integer(1) vector, indicating how many rows (header lines) to 
skip when the BED file is read into R.}

\item{withSeq}{A logical(1) vector, indicating that upstream and downstream 
sequences flanking pA sites are included in the file}

\item{upstream.seq.ind}{An integer(1),vector delineating the column 
location of upstream sequences of the putative pA site}

\item{downstream.seq.ind}{An integer(1),vector delineating the column 
location of downstream sequences of the putative pA site}
}
\value{
An object of GRanges
}
\description{
Convert to a GRanges object from a (extended) BED6 file with at least six 
columns: chrom, chromStart, strEnd, name, score and strand, and optional 
upstream sequences (including pA sites) and downstream sequences of pA sites
}
\examples{

testFile <- system.file("extdata", "test.bed",
                        package = "cleanUpdTSeq")
peaks <- BED6WithSeq2GRangesSeq(file = testFile, 
                               skip = 1L, withSeq = TRUE)

}
\author{
Haibo Liu, Lihua J. Zhu
}
