% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPlots.R
\name{volcanoPlot}
\alias{volcanoPlot}
\title{Plot differential circRNA expression results}
\usage{
volcanoPlot(
  res,
  log2FC = 1,
  padj = 0.05,
  title = "",
  gene = FALSE,
  geneSet = c(""),
  setxLim = FALSE,
  xlim = c(-8, 8),
  setyLim = FALSE,
  ylim = c(0, 5),
  color = "blue"
)
}
\arguments{
\item{res}{A data frame containing the the differential expression resuls.
It can be generated with \code{\link{getDeseqRes}} or
\code{\link{getEdgerRes}}.}

\item{log2FC}{An integer specifying the log2FC cut-off. Deafult value is 1.}

\item{padj}{An integer specifying the adjusted P value cut-off.
Deafult value is 0.05.}

\item{title}{A character string specifying the title of the plot.}

\item{gene}{A logical specifying whether to show all the host gene names of
the differentially expressed circRNAs to the plot. Deafult value is FALSE.}

\item{geneSet}{A character vector specifying which host gene name of
the differentially expressed circRNAs to show in the plot. Multiple host
gene names can be specofied. E.g. c('TTN, RyR2')}

\item{setxLim}{A logical specifying whether to set x scale limits.
If TRUE the value in xlim will be used. Deafult value is FALSE.}

\item{xlim}{A numeric vector specifying the lower and upper x axis limits.
Deafult values are c(-8 , 8).}

\item{setyLim}{A logical specifying whether to set y scale limits.
If TRUE the value in ylim will be used. Deafult value is FALSE.}

\item{ylim}{An integer specifying the lower and upper y axis limits
Deafult values are c(0, 5).}

\item{color}{A string specifying the color of the differentially expressed
circRNAs. Default value is "blue".}
}
\value{
A ggplot object.
}
\description{
The function volcanoPlot() generates a volcano plot with the
results of the differential expression analysis.
}
\examples{
# Load data frame containing detected back-spliced junctions
data("mergedBSJunctions")

pathToExperiment <- system.file("extdata", "experiment.txt",
    package ="circRNAprofiler")

# Filter circRNAs
filterdCirc <- filterCirc(
    mergedBSJunctions,
    allSamples = FALSE,
    min = 5,
    pathToExperiment)

# Find differentially expressed circRNAs
 deseqResBvsA <- getDeseqRes(
    filterdCirc,
    condition = "A-B",
    pAdjustMethod = "BH",
    pathToExperiment)

# Plot
p <- volcanoPlot(
    deseqResBvsA,
    log2FC = 1,
    padj = 0.05,
    title = "",
    setxLim = TRUE,
    xlim = c(-8 , 7.5),
    setyLim = FALSE,
    ylim = c(0 , 4),
    gene = FALSE)
p

}
