% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importFilesPredictionTool.R
\name{importNCLscan}
\alias{importNCLscan}
\title{Import circRNAs detected by NCLscan}
\usage{
importNCLscan(pathToFile)
}
\arguments{
\item{pathToFile}{A character string specifying the path to the file
containing the detected circRNAs.}
}
\value{
A data frame.
}
\description{
The function importNCLscan is specifically designed to read
and adapt the NCLscan v1.4 output file (e.g. MyProject.result). Only
intragenic circRNAs are kept in the analysis.
See \url{https://github.com/TreesLab/NCLscan} for more details.
}
\examples{
# Path to an example file containing circRNAs detected by NCLscan
pathToFile <- system.file("extdata", "nclscan/circRNAs_001.txt",
    package="circRNAprofiler")

# Inner function.
# Import circRNAs
importNCLscan(pathToFile)

}
\keyword{internal}
