% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSeqsFromGRs.R
\name{getSeqsFromGRs}
\alias{getSeqsFromGRs}
\title{Retrieve sequences flanking back-spliced junctions}
\usage{
getSeqsFromGRs(annotatedBSJs, genome, lIntron = 100, lExon = 10, type = "ie")
}
\arguments{
\item{annotatedBSJs}{A data frame with the annotated back-spliced junctions.
This data frame can be generated with \code{\link{annotateBSJs}}.}

\item{genome}{A BSgenome object containing the genome sequences.
It can be generated with in \code{\link{getBSgenome}}.
See \code{\link[BSgenome]{available.genomes}} to see the BSgenome package
currently available}

\item{lIntron}{An integer indicating how many nucleotides are taken from
the introns flanking the back-spliced junctions. This number must be
positive. Default value is 100.}

\item{lExon}{An integer indicating how many nucleotides are taken from
the back-spliced exons starting from the back-spliced junctions. This number
must be positive. Default value is 10.}

\item{type}{A character string specifying the sequences to retrieve.
If type = "ie" the sequences are retrieved from the the genomic ranges
defined by using the lIntron and lExon given in input. If type = "bse"
the sequences of the back-spliced exons are retrieved. If type = "fi"
the sequences of the introns flanking the back-spliced exons are retrieved.
Default value is "ie".}
}
\value{
A list.
}
\description{
The function getSeqsFromGRs() includes 3 modules to retrieve
3 types of sequences. Sequences of the introns flanking back-spliced
junctions, sequences from a defined genomic window surrounding the
back-spliced junctions and sequences of the back-spliced exons.
}
\examples{
# Load data frame containing predicted back-spliced junctions
data("mergedBSJunctions")

# Load short version of the gencode v19 annotation file
data("gtf")

# Annotate the first back-spliced junctions
annotatedBSJs <- annotateBSJs(mergedBSJunctions[1, ], gtf)

# Get genome
if (requireNamespace("BSgenome.Hsapiens.UCSC.hg19", quietly = TRUE)){
genome <- BSgenome::getBSgenome("BSgenome.Hsapiens.UCSC.hg19")

# Retrieve target sequences
targets <- getSeqsFromGRs(
    annotatedBSJs,
    genome,
    lIntron = 200,
    lExon = 10,
    type = "ie"
    )
}

}
