context("test-aggregate.R")

data("cicero_data")
test_cds <- suppressWarnings(make_atac_cds(cicero_data))

test_cds2 <- suppressWarnings(make_atac_cds(cicero_data))
exprs(test_cds2) <- as.matrix(exprs(test_cds2))

test_that("aggregate_nearby_peaks makes a valid cds object", {
  #skip_on_bioc()
  agg_cds <- aggregate_nearby_peaks(test_cds, 10000)
  expect_is(agg_cds, "CellDataSet")
  expect_equal(nrow(exprs(agg_cds)), 1690)
  expect_equal(ncol(exprs(agg_cds)), 200)
  expect_equal(exprs(agg_cds)[1,4], 4)
  expect_match(row.names(agg_cds)[1], "chr18_10006196_10017274")
  expect_match(colnames(agg_cds)[1], "AGCGATAGAACGAATTCGGCGCAATGACCCTATCCT")
  expect_is(exprs(agg_cds), "dgCMatrix")
})

test_that("aggregate_nearby_peaks makes a valid cds object not sparse", {
  #skip_on_bioc()
  agg_cds <- aggregate_nearby_peaks(test_cds2, 10000)
  expect_is(agg_cds, "CellDataSet")
  expect_equal(nrow(exprs(agg_cds)), 1690)
  expect_equal(ncol(exprs(agg_cds)), 200)
  expect_equal(exprs(agg_cds)[1,4], 4)
  expect_match(row.names(agg_cds)[1], "chr18_10006196_10017274")
  expect_match(colnames(agg_cds)[1], "AGCGATAGAACGAATTCGGCGCAATGACCCTATCCT")
  expect_is(exprs(agg_cds), "matrix")
})

test_that("aggregate_by_cell_bin makes a valid cds object", {
  #skip_on_bioc()
  pData(test_cds)$cell_subtype <- rep(1:10, times= 20)
  agg_cds2 <- suppressMessages(aggregate_by_cell_bin(test_cds, "cell_subtype"))
  expect_is(agg_cds2, "CellDataSet")
  expect_equal(nrow(exprs(agg_cds2)), 6146)
  expect_equal(ncol(exprs(agg_cds2)), 10)
  expect_equal(exprs(agg_cds2)[1,4], 2)
  expect_match(row.names(agg_cds2)[1], "chr18_10006196_10006822")
  expect_match(colnames(agg_cds2)[1], "1")
  expect_is(exprs(agg_cds2), "matrix")
})

test_that("aggregate_by_cell_bin makes a valid cds object not sparse", {
  #skip_on_bioc()
  pData(test_cds2)$cell_subtype <- rep(1:10, times= 20)
  agg_cds2 <- suppressMessages(aggregate_by_cell_bin(test_cds2, "cell_subtype"))
  expect_is(agg_cds2, "CellDataSet")
  expect_equal(nrow(exprs(agg_cds2)), 6146)
  expect_equal(ncol(exprs(agg_cds2)), 10)
  expect_equal(exprs(agg_cds2)[1,4], 2)
  expect_match(row.names(agg_cds2)[1], "chr18_10006196_10006822")
  expect_match(colnames(agg_cds2)[1], "1")
  expect_is(exprs(agg_cds2), "matrix")
})
